/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.MarkerMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.unification.stack.WildcardAwareHashMap;
import gregtech.api.util.CustomModPriorityComparator;
import gregtech.common.ConfigHolder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUnifier {
    private static final Map<String, MarkerMaterial> markerMaterialRegistry = new HashMap<String, MarkerMaterial>();
    private static final Map<ItemAndMetadata, ItemMaterialInfo> materialUnificationInfo = new WildcardAwareHashMap<ItemMaterialInfo>();
    private static final Map<ItemAndMetadata, UnificationEntry> stackUnificationInfo = new WildcardAwareHashMap<UnificationEntry>();
    private static final Map<UnificationEntry, ArrayList<ItemAndMetadata>> stackUnificationItems = new HashMap<UnificationEntry, ArrayList<ItemAndMetadata>>();
    private static final Map<ItemAndMetadata, Set<String>> stackOreDictName = new WildcardAwareHashMap<Set<String>>();
    private static final Map<String, List<ItemStack>> oreDictNameStacks = new HashMap<String, List<ItemStack>>();
    @Nullable
    private static Comparator<ItemAndMetadata> stackComparator;

    private OreDictUnifier() {
    }

    public static Comparator<ItemAndMetadata> getSimpleItemStackComparator() {
        if (stackComparator == null) {
            if (ConfigHolder.useCustomModPriorities) {
                List<String> modPriorities = Arrays.asList(ConfigHolder.modPriorities);
                stackComparator = Collections.reverseOrder(new CustomModPriorityComparator(modPriorities));
            } else {
                Function<ItemAndMetadata, String> modIdExtractor = stack -> stack.item.getRegistryName().func_110624_b();
                stackComparator = Comparator.comparing(modIdExtractor);
            }
        }
        return stackComparator;
    }

    public static Comparator<ItemStack> getItemStackComparator() {
        Comparator<ItemAndMetadata> comparator = OreDictUnifier.getSimpleItemStackComparator();
        return (first, second) -> comparator.compare(new ItemAndMetadata((ItemStack)first), new ItemAndMetadata((ItemStack)second));
    }

    public static void registerMarkerMaterial(MarkerMaterial markerMaterial) {
        if (markerMaterialRegistry.containsKey(markerMaterial.toString())) {
            throw new IllegalArgumentException("Marker material with id " + markerMaterial.toString() + " is already registered!");
        }
        markerMaterialRegistry.put(markerMaterial.toString(), markerMaterial);
    }

    public static void registerOre(ItemStack itemStack, ItemMaterialInfo materialInfo) {
        if (itemStack.func_190926_b()) {
            return;
        }
        materialUnificationInfo.put(new ItemAndMetadata(itemStack), materialInfo);
    }

    public static void registerOre(ItemStack itemStack, OrePrefix orePrefix, @Nullable Material material) {
        OreDictUnifier.registerOre(itemStack, orePrefix.name(), material);
    }

    public static void registerOre(ItemStack itemStack, String customOrePrefix, @Nullable Material material) {
        if (itemStack.func_190926_b()) {
            return;
        }
        OreDictionary.registerOre((String)(customOrePrefix + (material == null ? "" : material.toCamelCaseString())), (ItemStack)itemStack);
    }

    public static void registerOre(ItemStack itemStack, String oreDict) {
        if (itemStack.func_190926_b()) {
            return;
        }
        OreDictionary.registerOre((String)oreDict, (ItemStack)itemStack);
    }

    public static void init() {
        for (String registeredOreName : OreDictionary.getOreNames()) {
            NonNullList theseOres = OreDictionary.getOres((String)registeredOreName);
            for (ItemStack itemStack : theseOres) {
                OreDictUnifier.onItemRegistration(new OreDictionary.OreRegisterEvent(registeredOreName, itemStack));
            }
        }
        MinecraftForge.EVENT_BUS.register(OreDictUnifier.class);
    }

    @SubscribeEvent
    public static void onItemRegistration(OreDictionary.OreRegisterEvent event) {
        ItemAndMetadata simpleItemStack = new ItemAndMetadata(event.getOre());
        String oreName = event.getName();
        stackOreDictName.computeIfAbsent(simpleItemStack, k -> new HashSet()).add(oreName);
        List itemStackListForOreDictName = oreDictNameStacks.computeIfAbsent(oreName, k -> new ArrayList());
        OreDictUnifier.addAndSort(itemStackListForOreDictName, event.getOre().func_77946_l(), OreDictUnifier.getItemStackComparator());
        OrePrefix orePrefix = OrePrefix.getPrefix(oreName);
        Material material = null;
        if (orePrefix == null) {
            ArrayList<String> splits = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (char character : oreName.toCharArray()) {
                if (Character.isUpperCase(character)) {
                    if (builder.length() > 0) {
                        splits.add(builder.toString());
                        builder = new StringBuilder().append(character);
                        continue;
                    }
                    splits.add(Character.toString(character));
                    continue;
                }
                builder.append(character);
            }
            if (builder.length() > 0) {
                splits.add(builder.toString());
            }
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < splits.size(); ++i) {
                buffer.append((String)splits.get(i));
                OrePrefix maybePrefix = OrePrefix.getPrefix(buffer.toString());
                String possibleMaterialName = Joiner.on((String)"").join(splits.subList(i + 1, splits.size()));
                String underscoreName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, possibleMaterialName);
                Material possibleMaterial = (Material)Material.MATERIAL_REGISTRY.func_82594_a(underscoreName);
                if (possibleMaterial == null) {
                    possibleMaterial = markerMaterialRegistry.get(underscoreName);
                }
                if (maybePrefix == null || possibleMaterial == null) continue;
                orePrefix = maybePrefix;
                material = possibleMaterial;
                break;
            }
        }
        if (orePrefix != null && (material != null || orePrefix.isSelfReferencing)) {
            UnificationEntry unificationEntry = new UnificationEntry(orePrefix, material);
            ArrayList itemListForUnifiedEntry = stackUnificationItems.computeIfAbsent(unificationEntry, p -> new ArrayList());
            OreDictUnifier.addAndSort(itemListForUnifiedEntry, simpleItemStack, OreDictUnifier.getSimpleItemStackComparator());
            if (!unificationEntry.orePrefix.isMarkerPrefix()) {
                stackUnificationInfo.put(simpleItemStack, unificationEntry);
            }
            orePrefix.processOreRegistration(material);
        }
    }

    public static Set<String> getOreDictionaryNames(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return Collections.emptySet();
        }
        ItemAndMetadata simpleItemStack = new ItemAndMetadata(itemStack);
        if (stackOreDictName.containsKey(simpleItemStack)) {
            return Collections.unmodifiableSet(stackOreDictName.get(simpleItemStack));
        }
        return Collections.emptySet();
    }

    public static List<ItemStack> getAllWithOreDictionaryName(String oreDictionaryName) {
        return oreDictNameStacks.get(oreDictionaryName).stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
    }

    @Nullable
    public static MaterialStack getMaterial(ItemStack itemStack) {
        ItemMaterialInfo info;
        if (itemStack.func_190926_b()) {
            return null;
        }
        ItemAndMetadata simpleItemStack = new ItemAndMetadata(itemStack);
        UnificationEntry entry = stackUnificationInfo.get(simpleItemStack);
        if (entry != null) {
            Material entryMaterial = entry.material;
            if (entryMaterial == null) {
                entryMaterial = entry.orePrefix.materialType;
            }
            if (entryMaterial != null) {
                return new MaterialStack(entryMaterial, entry.orePrefix.materialAmount);
            }
        }
        return (info = materialUnificationInfo.get(simpleItemStack)) == null ? null : info.material.copy();
    }

    @Nullable
    public static OrePrefix getPrefix(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        ItemAndMetadata simpleItemStack = new ItemAndMetadata(itemStack);
        UnificationEntry entry = stackUnificationInfo.get(simpleItemStack);
        if (entry != null) {
            return entry.orePrefix;
        }
        return null;
    }

    @Nullable
    public static UnificationEntry getUnificationEntry(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        return stackUnificationInfo.get(new ItemAndMetadata(itemStack));
    }

    public static ItemStack getUnificated(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry(itemStack);
        if (unificationEntry == null || !stackUnificationItems.containsKey(unificationEntry) || !unificationEntry.orePrefix.isUnificationEnabled) {
            return itemStack;
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.size() > 0 ? keys.get(0).toItemStack(itemStack.func_190916_E()) : itemStack;
    }

    public static ItemStack get(UnificationEntry unificationEntry) {
        return OreDictUnifier.get(unificationEntry.orePrefix, unificationEntry.material);
    }

    public static ItemStack get(OrePrefix orePrefix, Material material) {
        return OreDictUnifier.get(orePrefix, material, 1);
    }

    public static ItemStack get(OrePrefix orePrefix, Material material, int stackSize) {
        UnificationEntry unificationEntry = new UnificationEntry(orePrefix, material);
        if (!stackUnificationItems.containsKey(unificationEntry)) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.size() > 0 ? keys.get(0).toItemStack(stackSize) : ItemStack.field_190927_a;
    }

    public static ItemStack get(String oreDictName) {
        List<ItemStack> itemStacks = oreDictNameStacks.get(oreDictName);
        return itemStacks.size() > 0 ? itemStacks.get(0).func_77946_l() : ItemStack.field_190927_a;
    }

    public static List<Map.Entry<ItemStack, ItemMaterialInfo>> getAllItemInfos() {
        return materialUnificationInfo.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(((ItemAndMetadata)entry.getKey()).toItemStack(), entry.getValue())).collect(Collectors.toList());
    }

    public static List<ItemStack> getAll(UnificationEntry unificationEntry) {
        if (!stackUnificationItems.containsKey(unificationEntry)) {
            return Collections.emptyList();
        }
        ArrayList<ItemAndMetadata> keys = stackUnificationItems.get(unificationEntry);
        return keys.stream().map(ItemAndMetadata::toItemStack).collect(Collectors.toList());
    }

    public static ItemStack getDust(DustMaterial material, long materialAmount) {
        if (materialAmount <= 0L) {
            return ItemStack.field_190927_a;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return OreDictUnifier.get(OrePrefix.dust, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 4L % 3628800L == 0L || materialAmount >= 29030400L) {
            return OreDictUnifier.get(OrePrefix.dustSmall, material, (int)(materialAmount * 4L / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return OreDictUnifier.get(OrePrefix.dustTiny, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDust(MaterialStack materialStack) {
        return OreDictUnifier.getDust((DustMaterial)materialStack.material, materialStack.amount);
    }

    public static ItemStack getIngot(IngotMaterial material, long materialAmount) {
        if (materialAmount <= 0L) {
            return ItemStack.field_190927_a;
        }
        if (materialAmount % 3628800L == 0L || materialAmount >= 58060800L) {
            return OreDictUnifier.get(OrePrefix.ingot, material, (int)(materialAmount / 3628800L));
        }
        if (materialAmount * 9L >= 3628800L) {
            return OreDictUnifier.get(OrePrefix.nugget, material, (int)(materialAmount * 9L / 3628800L));
        }
        return ItemStack.field_190927_a;
    }

    private static synchronized <T> void addAndSort(List<T> list, T itemToAdd, Comparator<T> comparator) {
        list.add(itemToAdd);
        if (list.size() > 1) {
            list.sort(comparator);
        }
    }
}

