/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.type;

import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.IngotMaterial")
@ZenRegister
public class IngotMaterial
extends SolidMaterial {
    public IngotMaterial smeltInto;
    public IngotMaterial arcSmeltInto;
    @Nullable
    public IngotMaterial magneticMaterial;
    @ZenProperty
    public final int blastFurnaceTemperature;
    @Nullable
    public WireProperties cableProperties;
    @Nullable
    public FluidPipeProperties fluidPipeProperties;

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element, float toolSpeed, float attackDamage, int toolDurability, int blastFurnaceTemperature) {
        super(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, element, toolSpeed, attackDamage, toolDurability);
        this.blastFurnaceTemperature = blastFurnaceTemperature;
        this.smeltInto = this;
        this.arcSmeltInto = this;
        this.addFlag(DustMaterial.MatFlags.SMELT_INTO_FLUID);
    }

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element) {
        this(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, element, 0.0f, 0.0f, 0, 0);
    }

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element, int blastFurnaceTemperature) {
        this(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, element, 0.0f, 0.0f, 0, blastFurnaceTemperature);
    }

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element, float toolSpeed, float attackDamage, int toolDurability) {
        this(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, element, toolSpeed, attackDamage, toolDurability, 0);
    }

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, float toolSpeed, float attackDamage, int toolDurability) {
        this(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, null, toolSpeed, attackDamage, toolDurability, 0);
    }

    public IngotMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags) {
        this(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, null, 0.0f, 0.0f, 0, 0);
    }

    @Override
    protected void initializeMaterial() {
        super.initializeMaterial();
        if (this.blastFurnaceTemperature > 0) {
            this.setFluidTemperature(this.blastFurnaceTemperature);
        } else {
            this.setFluidTemperature(1273);
        }
    }

    @Override
    protected long verifyMaterialBits(long generationBits) {
        if ((generationBits & MatFlags.GENERATE_DENSE) > 0L) {
            generationBits |= DustMaterial.MatFlags.GENERATE_PLATE;
        }
        if ((generationBits & MatFlags.GENERATE_ROTOR) > 0L) {
            generationBits |= MatFlags.GENERATE_BOLT_SCREW;
            generationBits |= MatFlags.GENERATE_RING;
            generationBits |= DustMaterial.MatFlags.GENERATE_PLATE;
        }
        if ((generationBits & MatFlags.GENERATE_SMALL_GEAR) > 0L) {
            generationBits |= DustMaterial.MatFlags.GENERATE_PLATE;
        }
        if ((generationBits & MatFlags.GENERATE_FINE_WIRE) > 0L) {
            generationBits |= MatFlags.GENERATE_FOIL;
        }
        if ((generationBits & MatFlags.GENERATE_FOIL) > 0L) {
            generationBits |= DustMaterial.MatFlags.GENERATE_PLATE;
        }
        if ((generationBits & MatFlags.GENERATE_RING) > 0L) {
            generationBits |= SolidMaterial.MatFlags.GENERATE_ROD;
        }
        if ((generationBits & MatFlags.GENERATE_BOLT_SCREW) > 0L) {
            generationBits |= SolidMaterial.MatFlags.GENERATE_ROD;
        }
        return super.verifyMaterialBits(generationBits);
    }

    public void setSmeltingInto(IngotMaterial smeltInto) {
        this.smeltInto = smeltInto;
    }

    public void setArcSmeltingInto(IngotMaterial arcSmeltingInto) {
        this.arcSmeltInto = arcSmeltingInto;
    }

    @ZenMethod
    public void setCableProperties(long voltage, int baseAmperage, int lossPerBlock) {
        this.cableProperties = new WireProperties((int)voltage, baseAmperage, lossPerBlock);
    }

    @ZenMethod
    public void setFluidPipeProperties(int throughput, int maxTemperature, boolean gasProof) {
        this.fluidPipeProperties = new FluidPipeProperties(maxTemperature, throughput, gasProof);
    }

    public static final class MatFlags {
        public static final long GENERATE_FOIL = GTUtility.createFlag(25);
        public static final long GENERATE_BOLT_SCREW = GTUtility.createFlag(26);
        public static final long GENERATE_RING = GTUtility.createFlag(27);
        public static final long GENERATE_SPRING = GTUtility.createFlag(28);
        public static final long GENERATE_FINE_WIRE = GTUtility.createFlag(29);
        public static final long GENERATE_ROTOR = GTUtility.createFlag(30);
        public static final long GENERATE_SMALL_GEAR = GTUtility.createFlag(31);
        public static final long GENERATE_DENSE = GTUtility.createFlag(32);
        public static final long GENERATE_SPRING_SMALL = GTUtility.createFlag(33);
        public static final long BLAST_FURNACE_CALCITE_DOUBLE = GTUtility.createFlag(35);
        public static final long BLAST_FURNACE_CALCITE_TRIPLE = GTUtility.createFlag(36);

        static {
            Material.MatFlags.registerMaterialFlagsHolder(MatFlags.class, IngotMaterial.class);
        }
    }
}

