/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.type;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.IMaterialHandler;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.Material")
@ZenRegister
public abstract class Material
implements Comparable<Material> {
    public static final GTControlledRegistry<String, Material> MATERIAL_REGISTRY = new GTControlledRegistry(1000);
    private static final List<IMaterialHandler> materialHandlers = new ArrayList<IMaterialHandler>();
    @ZenProperty(value="color")
    public final int materialRGB;
    @ZenProperty
    public final String chemicalFormula;
    @ZenProperty(value="iconSet")
    public final MaterialIconSet materialIconSet;
    @ZenProperty(value="components")
    public final ImmutableList<MaterialStack> materialComponents;
    @ZenProperty(value="generationFlagsRaw")
    protected long materialGenerationFlags;
    @ZenProperty
    public final Element element;

    public static void registerMaterialHandler(IMaterialHandler materialHandler) {
        materialHandlers.add(materialHandler);
    }

    public static void runMaterialHandlers() {
        materialHandlers.forEach(IMaterialHandler::onMaterialsInit);
    }

    public static void freezeRegistry() {
        GTLog.logger.info("Freezing material registry...");
        MATERIAL_REGISTRY.freezeRegistry();
    }

    private String calculateChemicalFormula() {
        if (this.element != null) {
            return this.element.name();
        }
        if (!this.materialComponents.isEmpty()) {
            StringBuilder components = new StringBuilder();
            for (MaterialStack component : this.materialComponents) {
                components.append(component.toString());
            }
            return components.toString();
        }
        return "";
    }

    public Material(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element) {
        this.materialRGB = materialRGB;
        this.materialIconSet = materialIconSet;
        this.materialComponents = materialComponents;
        this.materialGenerationFlags = this.verifyMaterialBits(materialGenerationFlags);
        this.element = element;
        this.chemicalFormula = this.calculateChemicalFormula();
        this.calculateDecompositionType();
        this.initializeMaterial();
        this.registerMaterial(metaItemSubId, name);
    }

    protected void registerMaterial(int metaItemSubId, String name) {
        MATERIAL_REGISTRY.register(metaItemSubId, name, this);
    }

    protected void initializeMaterial() {
    }

    protected long verifyMaterialBits(long materialBits) {
        return materialBits;
    }

    public void addFlag(long ... materialGenerationFlags) {
        if (MATERIAL_REGISTRY.isFrozen()) {
            throw new IllegalStateException("Cannot add flag to material when registry is frozen!");
        }
        long combined = 0L;
        for (long materialGenerationFlag : materialGenerationFlags) {
            combined |= materialGenerationFlag;
        }
        this.materialGenerationFlags |= this.verifyMaterialBits(combined);
    }

    @ZenMethod(value="hasFlagRaw")
    public boolean hasFlag(long generationFlag) {
        return (this.materialGenerationFlags & generationFlag) >= generationFlag;
    }

    @ZenMethod
    public void addFlags(String ... flagNames) {
        this.addFlag(Material.convertMaterialFlags(this.getClass(), flagNames));
    }

    public static long convertMaterialFlags(Class<? extends Material> materialClass, String ... flagNames) {
        long combined = 0L;
        for (String flagName : flagNames) {
            long materialFlagId = MatFlags.resolveFlag(flagName, materialClass);
            combined |= materialFlagId;
        }
        return combined;
    }

    @ZenMethod
    public boolean hasFlag(String flagName) {
        long materialFlagId = MatFlags.resolveFlag(flagName, this.getClass());
        return this.hasFlag(materialFlagId);
    }

    protected void calculateDecompositionType() {
        if (!(this.materialComponents.isEmpty() || this.hasFlag(MatFlags.DECOMPOSITION_BY_CENTRIFUGING) || this.hasFlag(MatFlags.DECOMPOSITION_BY_ELECTROLYZING) || this.hasFlag(MatFlags.DISABLE_DECOMPOSITION))) {
            boolean onlyMetalMaterials = true;
            for (MaterialStack materialStack : this.materialComponents) {
                Material material = materialStack.material;
                onlyMetalMaterials &= material instanceof IngotMaterial;
            }
            this.materialGenerationFlags = onlyMetalMaterials ? (this.materialGenerationFlags |= MatFlags.DECOMPOSITION_BY_CENTRIFUGING) : (this.materialGenerationFlags |= MatFlags.DECOMPOSITION_BY_ELECTROLYZING);
        }
    }

    @ZenGetter(value="radioactive")
    public boolean isRadioactive() {
        if (this.element != null) {
            return this.element.halfLifeSeconds >= 0L;
        }
        for (MaterialStack material : this.materialComponents) {
            if (!material.material.isRadioactive()) continue;
            return true;
        }
        return false;
    }

    @ZenGetter(value="protons")
    public long getProtons() {
        if (this.element != null) {
            return this.element.getProtons();
        }
        if (this.materialComponents.isEmpty()) {
            return Element.Tc.getProtons();
        }
        long totalProtons = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalProtons += material.amount * material.material.getProtons();
        }
        return totalProtons;
    }

    @ZenGetter(value="neutrons")
    public long getNeutrons() {
        if (this.element != null) {
            return this.element.getNeutrons();
        }
        if (this.materialComponents.isEmpty()) {
            return Element.Tc.getNeutrons();
        }
        long totalNeutrons = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalNeutrons += material.amount * material.material.getNeutrons();
        }
        return totalNeutrons;
    }

    @ZenGetter(value="mass")
    public long getMass() {
        if (this.element != null) {
            return this.element.getMass();
        }
        if (this.materialComponents.isEmpty()) {
            return Element.Tc.getMass();
        }
        long totalMass = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalMass += material.amount * material.material.getMass();
        }
        return totalMass;
    }

    @ZenGetter(value="averageProtons")
    public long getAverageProtons() {
        if (this.element != null) {
            return this.element.getProtons();
        }
        if (this.materialComponents.isEmpty()) {
            return Element.Tc.getProtons();
        }
        long totalProtons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalAmount += material.amount;
            totalProtons += material.amount * material.material.getAverageProtons();
        }
        return totalProtons / totalAmount;
    }

    @ZenGetter(value="averageNeutrons")
    public long getAverageNeutrons() {
        if (this.element != null) {
            return this.element.getNeutrons();
        }
        if (this.materialComponents.isEmpty()) {
            return Element.Tc.getNeutrons();
        }
        long totalNeutrons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalAmount += material.amount;
            totalNeutrons += material.amount * material.material.getAverageNeutrons();
        }
        return totalNeutrons / totalAmount;
    }

    @ZenGetter(value="averageMass")
    public long getAverageMass() {
        if (this.element != null) {
            return this.element.getMass();
        }
        if (this.materialComponents.size() <= 0) {
            return Element.Tc.getMass();
        }
        long totalMass = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialComponents) {
            totalAmount += material.amount;
            totalMass += material.amount * material.material.getAverageMass();
        }
        return totalMass / totalAmount;
    }

    @ZenGetter(value="camelCaseName")
    public String toCamelCaseString() {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.toString());
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return "material." + this.toString();
    }

    @SideOnly(value=Side.CLIENT)
    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    @ZenMethod
    public int compareTo(Material material) {
        return this.toString().compareTo(material.toString());
    }

    @ZenGetter(value="name")
    public String toString() {
        return MATERIAL_REGISTRY.getNameForObject(this);
    }

    @ZenOperator(value=OperatorType.MUL)
    public MaterialStack createMaterialStack(long amount) {
        return new MaterialStack(this, amount);
    }

    public static final class MatFlags {
        private static final Map<String, Map.Entry<Long, Class<? extends Material>>> materialFlagRegistry = new TreeMap<String, Map.Entry<Long, Class<? extends Material>>>(String.CASE_INSENSITIVE_ORDER);
        public static final long DECOMPOSITION_BY_ELECTROLYZING = GTUtility.createFlag(40);
        public static final long DECOMPOSITION_BY_CENTRIFUGING = GTUtility.createFlag(41);
        public static final long BURNING = GTUtility.createFlag(7);
        public static final long FLAMMABLE = GTUtility.createFlag(42);
        public static final long EXPLOSIVE = GTUtility.createFlag(4);
        public static final long NO_UNIFICATION = GTUtility.createFlag(5);
        public static final long NO_RECYCLING = GTUtility.createFlag(6);
        public static final long DISABLE_DECOMPOSITION = GTUtility.createFlag(43);
        public static final long DECOMPOSITION_REQUIRES_HYDROGEN = GTUtility.createFlag(8);

        public static void registerMaterialFlag(String name, long value, Class<? extends Material> classFilter) {
            if (materialFlagRegistry.containsKey(name)) {
                throw new IllegalArgumentException("Flag with name " + name + " already registered!");
            }
            for (Map.Entry<Long, Class<? extends Material>> entry : materialFlagRegistry.values()) {
                if (entry.getKey() != value) continue;
                throw new IllegalArgumentException("Flag with ID " + MatFlags.getIntValueOfFlag(value) + " already registered!");
            }
            materialFlagRegistry.put(name, new AbstractMap.SimpleEntry<Long, Class<? extends Material>>(value, classFilter));
        }

        private static int getIntValueOfFlag(long value) {
            int index = 0;
            while (value != 1L) {
                value >>= 1;
                ++index;
            }
            return index;
        }

        public static void registerMaterialFlagsHolder(Class<?> holder, Class<? extends Material> lowerBounds) {
            for (Field holderField : holder.getFields()) {
                long flagValue;
                int modifiers = holderField.getModifiers();
                if (holderField.getType() != Long.TYPE || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                String flagName = holderField.getName();
                try {
                    flagValue = holderField.getLong(null);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
                MatFlags.registerMaterialFlag(flagName, flagValue, lowerBounds);
            }
        }

        public static long resolveFlag(String name, Class<? extends Material> selfClass) {
            Map.Entry<Long, Class<? extends Material>> flagEntry = materialFlagRegistry.get(name);
            if (flagEntry == null) {
                throw new IllegalArgumentException("Flag with name " + name + " not registered");
            }
            if (!flagEntry.getValue().isAssignableFrom(selfClass)) {
                throw new IllegalArgumentException("Flag " + name + " cannot be applied to material type " + selfClass.getSimpleName() + ", lower bound is " + flagEntry.getValue().getSimpleName());
            }
            return flagEntry.getKey();
        }

        static {
            MatFlags.registerMaterialFlagsHolder(MatFlags.class, Material.class);
        }
    }
}

