/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockInfo {
    public static final BlockInfo EMPTY = new BlockInfo(Blocks.field_150350_a);
    private final IBlockState blockState;
    private final TileEntity tileEntity;

    public BlockInfo(Block block) {
        this(block.func_176223_P());
    }

    public BlockInfo(IBlockState blockState) {
        this(blockState, null);
    }

    public BlockInfo(IBlockState blockState, TileEntity tileEntity) {
        this.blockState = blockState;
        this.tileEntity = tileEntity;
        Preconditions.checkArgument((tileEntity == null || blockState.func_177230_c().hasTileEntity(blockState) ? 1 : 0) != 0, (Object)"Cannot create block info with tile entity for block not having it");
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void apply(World world, BlockPos pos) {
        world.func_175656_a(pos, this.blockState);
        if (this.tileEntity != null) {
            world.func_175690_a(pos, this.tileEntity);
        }
    }
}

