/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;

public class ByteBufUtils {
    public static void writeRelativeBlockList(PacketBuffer buf, BlockPos origin, List<BlockPos> blockList) {
        buf.func_150787_b(blockList.size());
        for (BlockPos blockPos1 : blockList) {
            BlockPos blockPos = blockPos1.func_177973_b((Vec3i)origin);
            buf.func_150787_b(blockPos.func_177958_n());
            buf.func_150787_b(blockPos.func_177956_o());
            buf.func_150787_b(blockPos.func_177952_p());
        }
    }

    public static List<BlockPos> readRelativeBlockList(PacketBuffer buf, BlockPos origin) {
        ArrayList<BlockPos> resultList = new ArrayList<BlockPos>();
        int amount = buf.func_150792_a();
        for (int i = 0; i < amount; ++i) {
            int posX = origin.func_177958_n() + buf.func_150792_a();
            int posY = origin.func_177956_o() + buf.func_150792_a();
            int posZ = origin.func_177952_p() + buf.func_150792_a();
            resultList.add(new BlockPos(posX, posY, posZ));
        }
        return resultList;
    }

    public static void writeIntList(PacketBuffer buf, TIntList intList) {
        buf.func_150787_b(intList.size());
        for (int i = 0; i < intList.size(); ++i) {
            buf.func_150787_b(intList.get(i));
        }
    }

    public static TIntList readIntList(PacketBuffer buf) {
        TIntArrayList intArrayList = new TIntArrayList();
        int amount = buf.func_150792_a();
        for (int i = 0; i < amount; ++i) {
            intArrayList.add(buf.func_150792_a());
        }
        return intArrayList;
    }

    public static void writeFluidStack(PacketBuffer buf, @Nullable FluidStack fluidStack) {
        buf.writeBoolean(fluidStack != null);
        if (fluidStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            buf.func_150786_a(tagCompound);
        }
    }

    public static FluidStack readFluidStack(PacketBuffer buf) {
        if (!buf.readBoolean()) {
            return null;
        }
        try {
            NBTTagCompound tagCompound = buf.func_150793_b();
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void writeFluidStackDelta(PacketBuffer buf, FluidStack oldFluidStack, FluidStack newFluidStack) {
        if (oldFluidStack != null && oldFluidStack.isFluidEqual(newFluidStack)) {
            buf.writeBoolean(true);
            buf.func_150787_b(newFluidStack.amount);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeFluidStack(buf, newFluidStack);
        }
    }

    public static FluidStack readFluidStackDelta(PacketBuffer buf, FluidStack currentFluid) {
        if (buf.readBoolean()) {
            int newFluidAmount = buf.func_150792_a();
            if (currentFluid == null) {
                GTLog.logger.error("Received fluid stack delta without acquiring initial state!", new Throwable());
                return null;
            }
            return GTUtility.copyAmount(newFluidAmount, currentFluid);
        }
        return ByteBufUtils.readFluidStack(buf);
    }
}

