/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.base.CaseFormat;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.item.EnumDyeColor;

public class DyeUtil {
    public static EnumDyeColor determineDyeColor(int rgbColor) {
        Color c = new Color(rgbColor);
        HashMap<Double, EnumDyeColor> distances = new HashMap<Double, EnumDyeColor>();
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            Color c2 = new Color(dyeColor.field_193351_w);
            double distance = (c.getRed() - c2.getRed()) * (c.getRed() - c2.getRed()) + (c.getGreen() - c2.getGreen()) * (c.getGreen() - c2.getGreen()) + (c.getBlue() - c2.getBlue()) * (c.getBlue() - c2.getBlue());
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (EnumDyeColor)distances.get(min);
    }

    public static String getColorName(EnumDyeColor dyeColor) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, dyeColor.func_176610_l());
    }

    public static String getOrdictColorName(EnumDyeColor dyeColor) {
        String colorName = dyeColor == EnumDyeColor.SILVER ? "LightGray" : DyeUtil.getColorName(dyeColor);
        return "dye" + colorName;
    }
}

