/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gregtech.api.util.GTLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;

public class FileUtility {
    private static final JsonParser jsonParser = new JsonParser();

    private FileUtility() {
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        byte[] streamData = IOUtils.toByteArray((InputStream)inputStream);
        return new String(streamData, StandardCharsets.UTF_8);
    }

    public static InputStream writeInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject tryExtractFromFile(Path filePath) {
        try (InputStream fileStream = Files.newInputStream(filePath, new OpenOption[0]);){
            InputStreamReader streamReader = new InputStreamReader(fileStream);
            JsonObject jsonObject = jsonParser.parse((Reader)streamReader).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException exception) {
            GTLog.logger.error("Failed to read file on path {}", (Object)filePath, (Object)exception);
            return null;
        }
        catch (JsonParseException exception) {
            GTLog.logger.error("Failed to extract json from file", (Throwable)exception);
            return null;
        }
        catch (Exception exception) {
            GTLog.logger.error("Failed to extract json from file on path {}", (Object)filePath, (Object)exception);
        }
        return null;
    }
}

