/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.DummyContainer;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.api.util.Predicates;
import gregtech.api.util.StreamUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class InventoryUtils {
    public static int getNumberOfEmptySlotsInInventory(IItemHandler inventory) {
        return (int)StreamUtils.streamFrom(inventory).filter(ItemStack::func_190926_b).count();
    }

    public static List<ItemStack> deepCopy(IItemHandler inventory, boolean keepEmpty) {
        return StreamUtils.streamFrom(inventory).filter(Predicates.or(x -> keepEmpty, Predicates.not(ItemStack::func_190926_b))).map(ItemStack::func_77946_l).collect(Collectors.toList());
    }

    public static boolean simulateItemStackMerge(List<ItemStack> inputItems, IItemHandler inventory) {
        List<ItemStack> itemStacks = InventoryUtils.compactItemStacks(inputItems);
        int emptySlots = InventoryUtils.getNumberOfEmptySlotsInInventory(inventory);
        if (itemStacks.size() <= emptySlots) {
            return true;
        }
        itemStacks.sort(Comparator.comparingInt(ItemStack::func_190916_E));
        List<ItemStack> inventoryStacks = InventoryUtils.deepCopy(inventory, false);
        InventoryUtils.mergeItemStacks(itemStacks, inventoryStacks);
        return itemStacks.size() <= emptySlots;
    }

    static List<ItemStack> compactItemStacks(Collection<ItemStack> inputItems) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        Supplier<Map> mapSupplier = () -> new Object2IntOpenCustomHashMap(strategy);
        return inputItems.stream().filter(Predicates.not(ItemStack::func_190926_b)).collect(Collectors.toMap(Function.identity(), ItemStack::func_190916_E, Math::addExact, mapSupplier)).entrySet().stream().map(entry -> {
            ItemStack combined = ((ItemStack)entry.getKey()).func_77946_l();
            combined.func_190920_e(((Integer)entry.getValue()).intValue());
            return combined;
        }).map(InventoryUtils::normalizeItemStack).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static void mergeItemStacks(Collection<ItemStack> source, Collection<ItemStack> destination) {
        Iterator<ItemStack> sourceItemStacks = source.iterator();
        block0: while (sourceItemStacks.hasNext()) {
            ItemStack sourceItemStack = sourceItemStacks.next();
            for (ItemStack destItemStack : destination) {
                int availableSlots;
                if (!ItemStack.func_179545_c((ItemStack)destItemStack, (ItemStack)sourceItemStack) || !ItemStack.func_77970_a((ItemStack)destItemStack, (ItemStack)sourceItemStack) || (availableSlots = destItemStack.func_77976_d() - destItemStack.func_190916_E()) <= 0) continue;
                int itemCount = Math.min(availableSlots, sourceItemStack.func_190916_E());
                sourceItemStack.func_190918_g(itemCount);
                destItemStack.func_190917_f(itemCount);
                if (!sourceItemStack.func_190926_b()) continue;
                sourceItemStacks.remove();
                continue block0;
            }
        }
    }

    public static List<ItemStack> normalizeItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Collections.emptyList();
        }
        int maxCount = stack.func_77976_d();
        if (stack.func_190916_E() <= maxCount) {
            return Collections.singletonList(stack.func_77946_l());
        }
        return Collections.unmodifiableList(InventoryUtils.apportionStack(stack, maxCount));
    }

    public static List<ItemStack> apportionStack(ItemStack stack, int maxCount) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Cannot apportion an empty stack.");
        }
        if (maxCount <= 0) {
            throw new IllegalArgumentException("Count must be non-zero and positive.");
        }
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        int count = stack.func_190916_E();
        int numStacks = count / maxCount;
        int remainder = count % maxCount;
        for (int fullStackCount = numStacks; fullStackCount > 0; --fullStackCount) {
            ItemStack fullStack = stack.func_77946_l();
            fullStack.func_190920_e(maxCount);
            splitStacks.add(fullStack);
        }
        if (remainder > 0) {
            ItemStack partialStack = stack.func_77946_l();
            partialStack.func_190920_e(remainder);
            splitStacks.add(partialStack);
        }
        return splitStacks;
    }

    public static InventoryCrafting deepCopyInventoryCrafting(InventoryCrafting source) {
        InventoryCrafting result = new InventoryCrafting((Container)new DummyContainer(), source.func_174922_i(), source.func_174923_h());
        for (int i = 0; i < result.func_70302_i_(); ++i) {
            result.func_70299_a(i, source.func_70301_a(i).func_77946_l());
        }
        return result;
    }
}

