/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public class MTJsonGenerator {
    public static void main(String[] args) throws IOException {
        Path texturesPath = Paths.get("assets/gregtech/textures/items/metaitems", new String[0]);
        Path modelsPath = Paths.get("assets/gregtech/models/item/metaitems", new String[0]);
        Files.walk(texturesPath, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".png")).forEach(textureFile -> {
            String relativePath = texturesPath.relativize((Path)textureFile).toString().replace('\\', '/');
            String fileText = "{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n    \"layer0\": \"gregtech:items/metaitems/" + relativePath.replace(".png", "") + "\"\n  }\n}";
            Path modelPath = modelsPath.resolve(relativePath.replace(".png", ".json"));
            try {
                Files.createDirectories(modelPath.getParent(), new FileAttribute[0]);
                if (!Files.exists(modelPath, new LinkOption[0])) {
                    Files.write(modelPath, Collections.singleton(fileText), StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        });
    }
}

