/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.populator;

import com.google.gson.JsonObject;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.generator.GridEntryInfo;
import gregtech.api.worldgen.populator.VeinChunkPopulator;
import gregtech.common.MetaFluids;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.surfacerock.TileEntitySurfaceRock;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class SurfaceRockPopulator
implements VeinChunkPopulator {
    private Material material;
    private int failedGenerationCounter = 0;

    public SurfaceRockPopulator() {
    }

    public SurfaceRockPopulator(Material material) {
        this.material = material;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        this.material = OreConfigUtils.getMaterialByName(object.get("material").getAsString());
    }

    @Override
    public void initializeForVein(OreDepositDefinition definition) {
    }

    private Set<Material> findUndergroundMaterials(Collection<IBlockState> generatedBlocks) {
        HashSet<Material> result = new HashSet<Material>();
        for (IBlockState blockState : generatedBlocks) {
            Material resultMaterial;
            if (blockState.func_177230_c() instanceof IFluidBlock || blockState.func_177230_c() instanceof BlockLiquid) {
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
                resultMaterial = fluid == null ? null : MetaFluids.getMaterialFromFluid(fluid);
            } else {
                ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_180651_a(blockState));
                UnificationEntry entry = OreDictUnifier.getUnificationEntry(itemStack);
                Material material = resultMaterial = entry == null ? null : entry.material;
            }
            if (resultMaterial == null) continue;
            result.add(resultMaterial);
        }
        return result;
    }

    private void setStoneBlock(World world, BlockPos blockPos, Collection<Material> undergroundMaterials) {
        boolean surfaceRockPlaced = world.func_175656_a(blockPos, MetaBlocks.SURFACE_ROCK_NEW.func_176223_P());
        if (surfaceRockPlaced) {
            TileEntitySurfaceRock tileEntity = (TileEntitySurfaceRock)world.func_175625_s(blockPos);
            if (tileEntity != null) {
                tileEntity.setData(this.material, undergroundMaterials);
            }
        } else {
            ++this.failedGenerationCounter;
        }
    }

    @Override
    public void populateChunk(World world, int chunkX, int chunkZ, Random random, OreDepositDefinition definition, GridEntryInfo gridEntryInfo) {
        int stonesCount = random.nextInt(2);
        if (stonesCount > 0 && world.func_175624_G() != WorldType.field_77138_c) {
            Set<Material> undergroundMaterials = this.findUndergroundMaterials(gridEntryInfo.getGeneratedBlocks(definition, chunkX, chunkZ));
            if (undergroundMaterials.isEmpty()) {
                return;
            }
            for (int i = 0; i < stonesCount; ++i) {
                int randomZ;
                int randomX = chunkX * 16 + 8 + random.nextInt(16);
                BlockPos topBlockPos = world.func_175672_r(new BlockPos(randomX, 0, randomZ = chunkZ * 16 + 8 + random.nextInt(16)));
                Block blockAtPos = world.func_180495_p(topBlockPos).func_177230_c();
                if (!blockAtPos.func_176200_f((IBlockAccess)world, topBlockPos) || world.func_180495_p(topBlockPos).func_185904_a().func_76224_d() || !world.isSideSolid(topBlockPos.func_177977_b(), EnumFacing.UP)) continue;
                this.setStoneBlock(world, topBlockPos, undergroundMaterials);
            }
        }
        if (this.failedGenerationCounter == stonesCount && stonesCount > 0 && world.func_175624_G() != WorldType.field_77138_c) {
            GTLog.logger.debug("Failed to generate surface rocks for vein {} at chunk with position: x: {}, z: {}", (Object)definition.getDepositName(), (Object)chunkX, (Object)chunkZ);
        }
    }

    public Material getMaterial() {
        return this.material;
    }
}

