/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.MetaBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class MetaFluids {
    private static final Set<ResourceLocation> fluidSprites = new HashSet<ResourceLocation>();
    private static final Map<String, FluidMaterial> fluidToMaterialMappings = new HashMap<String, FluidMaterial>();
    private static final Map<String, String> alternativeFluidNames = new HashMap<String, String>();
    public static final ResourceLocation AUTO_GENERATED_FLUID_TEXTURE = new ResourceLocation("gregtech", "blocks/fluids/fluid.molten.autogenerated");
    private static final Map<Pair<FluidMaterial, FluidType>, ResourceLocation> fluidTextureMap = new HashMap<Pair<FluidMaterial, FluidType>, ResourceLocation>();
    public static final Fluid DISTILLED_WATER = new Fluid("distilled_water", new ResourceLocation("blocks/water_still"), new ResourceLocation("blocks/water_flow"));

    public static void registerSprites(TextureMap textureMap) {
        for (ResourceLocation spriteLocation : fluidSprites) {
            textureMap.func_174942_a(spriteLocation);
        }
    }

    public static void init() {
        Materials.Water.setMaterialFluid(FluidRegistry.WATER);
        Materials.Lava.setMaterialFluid(FluidRegistry.LAVA);
        FluidRegistry.registerFluid((Fluid)DISTILLED_WATER);
        Materials.DistilledWater.setMaterialFluid(DISTILLED_WATER);
        fluidSprites.add(AUTO_GENERATED_FLUID_TEXTURE);
        FluidTooltipUtil.registerTooltip(FluidRegistry.WATER, FluidTooltipUtil.getWaterTooltip());
        FluidTooltipUtil.registerTooltip(DISTILLED_WATER, FluidTooltipUtil.getWaterTooltip());
        MetaFluids.setAlternativeFluidName(Materials.Ethanol, FluidType.NORMAL, "bio.ethanol");
        MetaFluids.setAlternativeFluidName(Materials.Honey, FluidType.NORMAL, "for.honey");
        MetaFluids.setAlternativeFluidName(Materials.SeedOil, FluidType.NORMAL, "seed.oil");
        MetaFluids.setAlternativeFluidName(Materials.Ice, FluidType.NORMAL, "fluid.ice");
        MetaFluids.setDefaultTexture(Materials.Air, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Oxygen, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Hydrogen, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Deuterium, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Tritium, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Helium, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Argon, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Radon, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Fluorine, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.TitaniumTetrachloride, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Helium3, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Methane, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Nitrogen, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.NitrogenDioxide, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Steam, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.OilHeavy, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.OilMedium, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.OilLight, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.HydrogenSulfide, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SulfuricGas, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Gas, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SulfuricNaphtha, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SulfuricLightFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SulfuricHeavyFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Naphtha, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.LightFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.HeavyFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.LPG, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.CrackedLightFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.CrackedHeavyFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.UUAmplifier, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Chlorine, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Mercury, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.NitroFuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SodiumPersulfate, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Glyceryl, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Lubricant, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Creosote, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SeedOil, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Oil, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Fuel, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Honey, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Biomass, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Ethanol, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.SulfuricAcid, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Milk, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.McGuffium239, FluidType.NORMAL);
        MetaFluids.setDefaultTexture(Materials.Glue, FluidType.NORMAL);
        Iterator<gregtech.api.unification.material.type.Material> iterator = gregtech.api.unification.material.type.Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            gregtech.api.unification.material.type.Material material = iterator.next();
            if (!(material instanceof FluidMaterial)) continue;
            FluidMaterial fluidMaterial = (FluidMaterial)material;
            if (fluidMaterial.shouldGenerateFluid() && fluidMaterial.getMaterialFluid() == null) {
                int temperature = fluidMaterial.getFluidTemperature();
                Fluid fluid = MetaFluids.registerFluid(fluidMaterial, FluidType.NORMAL, temperature);
                fluidMaterial.setMaterialFluid(fluid);
                FluidTooltipUtil.registerTooltip(fluid, fluidMaterial.chemicalFormula);
            }
            if (!fluidMaterial.shouldGeneratePlasma() || fluidMaterial.getMaterialPlasma() != null) continue;
            Fluid fluid = MetaFluids.registerFluid(fluidMaterial, FluidType.PLASMA, 30000);
            fluidMaterial.setMaterialPlasma(fluid);
            FluidTooltipUtil.registerTooltip(fluid, fluidMaterial.chemicalFormula);
        }
    }

    private static void setDefaultTexture(FluidMaterial material, FluidType fluidType) {
        ResourceLocation resourceLocation = new ResourceLocation("gregtech", "blocks/fluids/fluid." + material.toString());
        MetaFluids.setMaterialFluidTexture(material, fluidType, resourceLocation);
    }

    private static void setMaterialFluidTexture(FluidMaterial material, FluidType fluidType, ResourceLocation textureLocation) {
        fluidTextureMap.put((Pair<FluidMaterial, FluidType>)Pair.of((Object)material, (Object)((Object)fluidType)), textureLocation);
        fluidSprites.add(textureLocation);
    }

    private static void setAlternativeFluidName(FluidMaterial material, FluidType fluidType, String alternativeName) {
        alternativeFluidNames.put(fluidType.getFluidName(material), alternativeName);
    }

    public static Fluid registerFluid(FluidMaterial material, FluidType fluidType, int temperature) {
        String materialName = material.toString();
        String fluidName = fluidType.getFluidName(material);
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null && alternativeFluidNames.containsKey(fluidName)) {
            String altName = alternativeFluidNames.get(fluidName);
            fluid = FluidRegistry.getFluid((String)altName);
        }
        if (fluid == null) {
            FluidState fluidState = fluidType.getFluidState(material);
            ResourceLocation textureLocation = fluidTextureMap.getOrDefault(Pair.of((Object)material, (Object)((Object)fluidType)), AUTO_GENERATED_FLUID_TEXTURE);
            fluid = new MaterialFluid(fluidName, material, fluidState, textureLocation);
            fluid.setTemperature(temperature);
            if (textureLocation == AUTO_GENERATED_FLUID_TEXTURE) {
                fluid.setColor(GTUtility.convertRGBtoOpaqueRGBA_MC(material.materialRGB));
            }
            MetaFluids.setStateProperties(fluid, fluidState);
            FluidRegistry.registerFluid((Fluid)fluid);
        }
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        if (material.hasFlag(FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK) && fluid.getBlock() == null && fluidType != FluidType.PLASMA) {
            BlockFluidClassic fluidBlock = new BlockFluidClassic(fluid, Material.field_151586_h);
            fluidBlock.setRegistryName("fluid." + materialName);
            MetaBlocks.FLUID_BLOCKS.add((BlockFluidBase)fluidBlock);
        }
        fluidToMaterialMappings.put(fluid.getName(), material);
        return fluid;
    }

    public static FluidMaterial getMaterialFromFluid(Fluid fluid) {
        return fluidToMaterialMappings.get(fluid.getName());
    }

    private static void setStateProperties(Fluid fluid, FluidState fluidState) {
        switch (fluidState) {
            case LIQUID: {
                fluid.setGaseous(false);
                fluid.setViscosity(1000);
                break;
            }
            case GAS: {
                fluid.setGaseous(true);
                fluid.setDensity(-100);
                fluid.setViscosity(200);
                break;
            }
            case PLASMA: {
                fluid.setGaseous(true);
                fluid.setDensity(55536);
                fluid.setViscosity(10);
                fluid.setLuminosity(15);
            }
        }
    }

    private static class MaterialFluid
    extends Fluid {
        private final FluidMaterial material;
        private final FluidState state;

        public MaterialFluid(String fluidName, FluidMaterial material, FluidState fluidState, ResourceLocation texture) {
            super(fluidName, texture, texture, GTUtility.convertRGBtoOpaqueRGBA_MC(material.materialRGB));
            this.material = material;
            this.state = fluidState;
        }

        public String getUnlocalizedName() {
            return this.material.getUnlocalizedName();
        }

        @SideOnly(value=Side.CLIENT)
        public String getLocalizedName(FluidStack stack) {
            String localizedName = I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
            if (this.state.prefixLocale != null) {
                return I18n.func_135052_a((String)this.state.prefixLocale, (Object[])new Object[]{localizedName});
            }
            return localizedName;
        }
    }

    public static enum FluidState {
        LIQUID(null),
        GAS(null),
        PLASMA("gregtech.fluid.plasma");

        private final String prefixLocale;

        private FluidState(String prefixLocale) {
            this.prefixLocale = prefixLocale;
        }
    }

    public static enum FluidType {
        NORMAL("", material -> material.hasFlag(FluidMaterial.MatFlags.STATE_GAS) ? FluidState.GAS : FluidState.LIQUID),
        PLASMA("plasma.", material -> FluidState.PLASMA);

        private final String prefix;
        private final Function<FluidMaterial, FluidState> stateFunction;

        private FluidType(String prefix, Function<FluidMaterial, FluidState> stateFunction) {
            this.prefix = prefix;
            this.stateFunction = stateFunction;
        }

        public String getFluidName(FluidMaterial fluidMaterial) {
            return this.prefix + fluidMaterial.toString();
        }

        public FluidState getFluidState(FluidMaterial fluidMaterial) {
            return this.stateFunction.apply(fluidMaterial);
        }
    }
}

