/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.common.blocks.VariantBlock;
import gregtech.common.blocks.VariantItemBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWireCoil
extends VariantBlock<CoilType> {
    public BlockWireCoil() {
        super(Material.field_151573_f);
        this.func_149663_c("wire_coil");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 2);
        this.func_180632_j(this.getState(CoilType.CUPRONICKEL));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable World worldIn, List<String> lines, ITooltipFlag tooltipFlag) {
        super.func_190948_a(itemStack, worldIn, lines, tooltipFlag);
        VariantItemBlock itemBlock = (VariantItemBlock)itemStack.func_77973_b();
        IBlockState stackState = itemBlock.getBlockState(itemStack);
        CoilType coilType = (CoilType)((Object)this.getState(stackState));
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_ebf", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_heat", (Object[])new Object[]{coilType.coilTemperature}));
        lines.add("");
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_smelter", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_level", (Object[])new Object[]{coilType.level}));
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_discount", (Object[])new Object[]{coilType.energyDiscount}));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public static enum CoilType implements IStringSerializable
    {
        CUPRONICKEL("cupronickel", 1800, 1, 1, Materials.Cupronickel),
        KANTHAL("kanthal", 2700, 2, 1, Materials.Kanthal),
        NICHROME("nichrome", 3600, 4, 1, Materials.Nichrome),
        TUNGSTENSTEEL("tungstensteel", 4500, 8, 1, Materials.TungstenSteel),
        HSS_G("hss_g", 5400, 8, 2, Materials.HSSG),
        NAQUADAH("naquadah", 7200, 16, 1, Materials.Naquadah),
        NAQUADAH_ALLOY("naquadah_alloy", 8600, 16, 2, Materials.NaquadahAlloy),
        SUPERCONDUCTOR("superconductor", 9001, 16, 4, MarkerMaterials.Tier.Superconductor),
        FUSION_COIL("fusion_coil", 9700, 16, 8, null);

        private final String name;
        private final int coilTemperature;
        private final int level;
        private final int energyDiscount;
        private final gregtech.api.unification.material.type.Material material;

        private CoilType(String name, int coilTemperature, int level, int energyDiscount, gregtech.api.unification.material.type.Material material) {
            this.name = name;
            this.coilTemperature = coilTemperature;
            this.level = level;
            this.energyDiscount = energyDiscount;
            this.material = material;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getCoilTemperature() {
            return this.coilTemperature;
        }

        public int getLevel() {
            return this.level;
        }

        public int getEnergyDiscount() {
            return this.energyDiscount;
        }

        public gregtech.api.unification.material.type.Material getMaterial() {
            return this.material;
        }
    }
}

