/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.surfacerock;

import gregtech.api.items.toolitem.IScannableBlock;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.blocks.surfacerock.TileEntitySurfaceRock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSurfaceRockNew
extends BlockSurfaceRock
implements ITileEntityProvider,
IScannableBlock {
    protected ThreadLocal<TileEntitySurfaceRock> tileEntities = new ThreadLocal();

    public BlockSurfaceRockNew() {
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public List<ITextComponent> getMagnifyResults(IBlockAccess world, BlockPos pos, IBlockState blockState, EntityPlayer player) {
        TileEntitySurfaceRock tileEntity = BlockSurfaceRockNew.getTileEntity(world, pos);
        if (tileEntity == null) {
            return Collections.emptyList();
        }
        List<Material> materials = tileEntity.getUndergroundMaterials();
        TextComponentTranslation materialComponent = new TextComponentTranslation(tileEntity.getMaterial().getUnlocalizedName(), new Object[0]);
        materialComponent.func_150256_b().func_150238_a(TextFormatting.GREEN);
        TextComponentString baseComponent = new TextComponentString("");
        TextComponentString separator = new TextComponentString(", ");
        separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
        for (int i = 0; i < materials.size(); ++i) {
            TextComponentTranslation extraComponent = new TextComponentTranslation(materials.get(i).getUnlocalizedName(), new Object[0]);
            extraComponent.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            baseComponent.func_150257_a((ITextComponent)extraComponent);
            if (i + 1 == materials.size()) continue;
            baseComponent.func_150257_a((ITextComponent)separator);
        }
        ArrayList<ITextComponent> result = new ArrayList<ITextComponent>();
        result.add((ITextComponent)new TextComponentTranslation("gregtech.block.surface_rock.material", new Object[]{materialComponent}));
        result.add((ITextComponent)new TextComponentTranslation("gregtech.block.surface_rock.underground_materials", new Object[]{baseComponent}));
        return result;
    }

    @Override
    public Material getStoneMaterial(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState) {
        TileEntitySurfaceRock surfaceRockTileEntity = BlockSurfaceRockNew.getTileEntity(blockAccess, pos);
        if (surfaceRockTileEntity == null) {
            surfaceRockTileEntity = this.tileEntities.get();
        }
        if (surfaceRockTileEntity != null) {
            return surfaceRockTileEntity.getMaterial();
        }
        return Materials.Aluminium;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntitySurfaceRock surfaceRockTileEntity = BlockSurfaceRockNew.getTileEntity((IBlockAccess)worldIn, pos);
        if (surfaceRockTileEntity != null) {
            this.tileEntities.set(surfaceRockTileEntity);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        this.tileEntities.set(te == null ? this.tileEntities.get() : (TileEntitySurfaceRock)te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.set(null);
    }

    public static TileEntitySurfaceRock getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySurfaceRock) {
            return (TileEntitySurfaceRock)tileEntity;
        }
        return null;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySurfaceRock();
    }
}

