/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.wood;

import gregtech.api.GregTechAPI;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregLeaves;
import gregtech.common.blocks.wood.BlockGregLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockGregSapling
extends BlockBush
implements IGrowable,
IPlantable {
    public static final PropertyEnum<BlockGregLog.LogVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockGregLog.LogVariant.class);
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public BlockGregSapling() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)BlockGregLog.LogVariant.RUBBER_WOOD)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("gt.sapling");
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockGregLog.LogVariant.values()[meta % 4 % BlockGregLog.LogVariant.values().length])).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta / 4 % 2));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) * 4 + ((BlockGregLog.LogVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockGregLog.LogVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (BlockGregLog.LogVariant logVariant : BlockGregLog.LogVariant.values()) {
            items.add((Object)new ItemStack((Block)this, 1, logVariant.ordinal()));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        IBlockState logState = MetaBlocks.LOG.func_176223_P().func_177226_a(BlockGregLog.VARIANT, (Comparable)((Object)BlockGregLog.LogVariant.RUBBER_WOOD)).func_177226_a((IProperty)BlockGregLog.NATURAL, (Comparable)Boolean.valueOf(true));
        IBlockState leavesState = MetaBlocks.LEAVES.func_176223_P().func_177226_a(BlockGregLeaves.VARIANT, (Comparable)((Object)BlockGregLog.LogVariant.RUBBER_WOOD));
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTreeCustom(true, logState, leavesState.func_177226_a((IProperty)BlockGregLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), (PropertyEnum<BlockLog.EnumAxis>)BlockGregLog.field_176299_a) : new WorldGenTrees(true, 6, logState, leavesState, false);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!worldgenerator.func_180709_b(worldIn, rand, pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public static class WorldGenBigTreeCustom
    extends WorldGenBigTree {
        private final IBlockState logBlock;
        private final IBlockState leavesBlock;
        private final PropertyEnum<BlockLog.EnumAxis> logAxisProperty;

        public WorldGenBigTreeCustom(boolean notify, IBlockState logBlock, IBlockState leavesBlock, PropertyEnum<BlockLog.EnumAxis> logAxisProperty) {
            super(notify);
            this.logBlock = logBlock;
            this.leavesBlock = leavesBlock;
            this.logAxisProperty = logAxisProperty;
        }

        protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
            if (state.func_177230_c() instanceof BlockLeaves) {
                state = this.leavesBlock;
            } else if (state.func_177230_c() instanceof BlockLog) {
                BlockLog.EnumAxis rotation = (BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a);
                state = this.logBlock.func_177226_a(this.logAxisProperty, (Comparable)rotation);
            }
            super.func_175903_a(worldIn, pos, state);
        }
    }
}

