/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.command.util;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.materialitem.MaterialMetaItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IToolStats;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.ClipboardUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CommandHand
extends CommandBase {
    public String func_71517_b() {
        return "hand";
    }

    public String func_71518_a(ICommandSender sender) {
        return "gregtech.command.util.hand.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            ItemStack stackInHand = player.field_71071_by.func_70448_g();
            if (stackInHand.func_190926_b()) {
                throw new CommandException("gregtech.command.util.hand.no_item", new Object[0]);
            }
            String registryName = stackInHand.func_77973_b().getRegistryName().toString();
            ClickEvent itemNameEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, registryName);
            player.func_145747_a(new TextComponentTranslation("gregtech.command.util.hand.item_id", new Object[]{registryName, stackInHand.func_77952_i()}).func_150255_a(new Style().func_150241_a(itemNameEvent)));
            IElectricItem electricItem = (IElectricItem)stackInHand.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stackInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (electricItem != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.electric", new Object[]{electricItem.getCharge(), electricItem.getMaxCharge(), electricItem.getTier(), Boolean.toString(electricItem.canProvideChargeExternally())}));
            }
            if (fluidHandlerItem != null) {
                for (IFluidTankProperties properties : fluidHandlerItem.getTankProperties()) {
                    FluidStack contents = properties.getContents();
                    String fluidName = contents == null ? "empty" : contents.getFluid().getName();
                    ClickEvent fluidClickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, fluidName);
                    player.func_145747_a(new TextComponentTranslation("gregtech.command.util.hand.fluid", new Object[]{fluidName, contents == null ? 0 : contents.amount, properties.getCapacity(), Boolean.toString(properties.canFill()), Boolean.toString(properties.canDrain())}).func_150255_a(new Style().func_150241_a(fluidClickEvent)));
                }
            }
            if (stackInHand.func_77973_b() instanceof MetaItem) {
                MetaItem metaItem = (MetaItem)stackInHand.func_77973_b();
                Object metaValueItem = metaItem.getItem(stackInHand);
                if (metaValueItem == null) {
                    if (metaItem instanceof MaterialMetaItem) {
                        Material material = ((MaterialMetaItem)metaItem).getMaterial(stackInHand);
                        OrePrefix orePrefix = ((MaterialMetaItem)metaItem).getOrePrefix(stackInHand);
                        String oreDictName = new UnificationEntry(orePrefix, material).toString();
                        player.func_145747_a(new TextComponentTranslation("gregtech.command.util.hand.material_meta_item", new Object[]{orePrefix, material}).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, oreDictName))));
                    }
                } else {
                    if (metaValueItem instanceof ToolMetaItem.MetaToolValueItem) {
                        IToolStats toolStats = ((ToolMetaItem.MetaToolValueItem)metaValueItem).getToolStats();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.tool_stats", new Object[]{toolStats.getClass().getName()}));
                    }
                    ClipboardUtil.copyToClipboard(player, ((MetaItem.MetaValueItem)metaValueItem).unlocalizedName);
                    ClickEvent metaItemEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, ((MetaItem.MetaValueItem)metaValueItem).unlocalizedName);
                    player.func_145747_a(new TextComponentTranslation("gregtech.command.util.hand.meta_item", new Object[]{((MetaItem.MetaValueItem)metaValueItem).unlocalizedName, metaValueItem}).func_150255_a(new Style().func_150241_a(metaItemEvent)));
                }
            }
        } else {
            throw new CommandException("gregtech.command.util.hand.not_a_player", new Object[0]);
        }
    }
}

