/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GTValues;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.render.Textures;
import gregtech.api.util.GTLog;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverFacade;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverMachineController;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.CoverSolarPanel;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SimpleFluidFilter;
import gregtech.common.covers.filter.SimpleItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CoverBehaviors {
    private static final int COVERS_PER_ITEM = 8;

    public static void init() {
        GTLog.logger.info("Registering cover behaviors...");
        CoverBehaviors.registerBehavior(0, new ResourceLocation("gregtech", "conveyor.lv"), MetaItems.CONVEYOR_MODULE_LV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(1, new ResourceLocation("gregtech", "conveyor.mv"), MetaItems.CONVEYOR_MODULE_MV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(2, new ResourceLocation("gregtech", "conveyor.hv"), MetaItems.CONVEYOR_MODULE_HV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(3, new ResourceLocation("gregtech", "conveyor.ev"), MetaItems.CONVEYOR_MODULE_EV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(4, new ResourceLocation("gregtech", "conveyor.iv"), MetaItems.CONVEYOR_MODULE_IV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(5, new ResourceLocation("gregtech", "conveyor.luv"), MetaItems.CONVEYOR_MODULE_LUV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(6, new ResourceLocation("gregtech", "conveyor.zpm"), MetaItems.CONVEYOR_MODULE_ZPM, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(7, new ResourceLocation("gregtech", "conveyor.uv"), MetaItems.CONVEYOR_MODULE_UV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(10, new ResourceLocation("gregtech", "robotic_arm.lv"), MetaItems.ROBOT_ARM_LV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(11, new ResourceLocation("gregtech", "robotic_arm.mv"), MetaItems.ROBOT_ARM_MV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(12, new ResourceLocation("gregtech", "robotic_arm.hv"), MetaItems.ROBOT_ARM_HV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(13, new ResourceLocation("gregtech", "robotic_arm.ev"), MetaItems.ROBOT_ARM_EV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(14, new ResourceLocation("gregtech", "robotic_arm.iv"), MetaItems.ROBOT_ARM_IV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(15, new ResourceLocation("gregtech", "robotic_arm.luv"), MetaItems.ROBOT_ARM_LUV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(16, new ResourceLocation("gregtech", "robotic_arm.zpm"), MetaItems.ROBOT_ARM_ZPM, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(17, new ResourceLocation("gregtech", "robotic_arm.uv"), MetaItems.ROBOT_ARM_UV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(30, new ResourceLocation("gregtech", "ore_dictionary_filter"), MetaItems.ORE_DICTIONARY_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.ore_dictionary_filter.title", Textures.ORE_DICTIONARY_FILTER_OVERLAY, new OreDictionaryItemFilter()));
        CoverBehaviors.registerBehavior(31, new ResourceLocation("gregtech", "item_filter"), MetaItems.ITEM_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.item_filter.title", Textures.ITEM_FILTER_FILTER_OVERLAY, new SimpleItemFilter()));
        CoverBehaviors.registerBehavior(32, new ResourceLocation("gregtech", "fluid_filter"), MetaItems.FLUID_FILTER, (tile, side) -> new CoverFluidFilter((ICoverable)tile, (EnumFacing)side, "cover.fluid_filter.title", Textures.FLUID_FILTER_OVERLAY, new SimpleFluidFilter()));
        CoverBehaviors.registerBehavior(33, new ResourceLocation("gregtech", "shutter"), MetaItems.COVER_SHUTTER, CoverShutter::new);
        CoverBehaviors.registerBehavior(34, new ResourceLocation("gregtech", "solar_panel.basic"), MetaItems.COVER_SOLAR_PANEL, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 1));
        CoverBehaviors.registerBehavior(35, new ResourceLocation("gregtech", "solar_panel.ulv"), MetaItems.COVER_SOLAR_PANEL_ULV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 8));
        CoverBehaviors.registerBehavior(36, new ResourceLocation("gregtech", "solar_panel.lv"), MetaItems.COVER_SOLAR_PANEL_LV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 32));
        CoverBehaviors.registerBehavior(37, new ResourceLocation("gregtech", "machine_controller"), MetaItems.COVER_MACHINE_CONTROLLER, CoverMachineController::new);
        CoverBehaviors.registerBehavior(38, new ResourceLocation("gregtech", "smart_filter"), MetaItems.SMART_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.smart_item_filter.title", Textures.SMART_FILTER_FILTER_OVERLAY, new SmartItemFilter()));
        CoverBehaviors.registerBehavior(39, new ResourceLocation("gregtech", "facade"), MetaItems.COVER_FACADE, CoverFacade::new);
        for (int i = 0; i < 8; ++i) {
            int throughput = (int)(Math.pow(4.0, i) * 1280.0);
            int coverTier = i + 1;
            String tierShortName = GTValues.VN[coverTier].toLowerCase(Locale.ROOT);
            CoverBehaviors.registerBehavior(20 + i, new ResourceLocation("gregtech", "pump." + tierShortName), MetaItems.PUMPS[i], (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, coverTier, throughput));
            CoverBehaviors.registerBehavior(40 + i, new ResourceLocation("gregtech", "fluid.regulator." + tierShortName), MetaItems.FLUID_REGULATORS[i], (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, coverTier, throughput));
        }
    }

    public static void registerBehavior(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem placerItem, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, placerItem.getStackForm());
        CoverDefinition.registerCover(coverNetworkId, coverDefinition);
        placerItem.addComponents(new CoverPlaceBehavior(coverDefinition));
    }
}

