/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.GTFluidUtils;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.filter.FluidFilterContainer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoverPump
extends CoverBehavior
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxFluidTransferRate;
    protected int transferRate;
    protected PumpMode pumpMode;
    protected ManualImportExportMode manualImportExportMode = ManualImportExportMode.DISABLED;
    protected int fluidLeftToTransferLastSecond;
    private CoverableFluidHandlerWrapper fluidHandlerWrapper;
    protected boolean isWorkingAllowed = true;
    protected final FluidFilterContainer fluidFilter;
    protected BucketMode bucketMode;

    public CoverPump(ICoverable coverHolder, EnumFacing attachedSide, int tier, int mbPerTick) {
        super(coverHolder, attachedSide);
        this.tier = tier;
        this.maxFluidTransferRate = mbPerTick;
        this.fluidLeftToTransferLastSecond = this.transferRate = mbPerTick;
        this.pumpMode = PumpMode.EXPORT;
        this.bucketMode = BucketMode.MILLI_BUCKET;
        this.fluidFilter = new FluidFilterContainer(this);
    }

    protected void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        this.coverHolder.markDirty();
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + (amount *= this.bucketMode == BucketMode.BUCKET ? 1000 : 1)), (int)1, (int)this.maxFluidTransferRate));
    }

    public void setPumpMode(PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.coverHolder.markDirty();
    }

    public PumpMode getPumpMode() {
        return this.pumpMode;
    }

    public void setBucketMode(BucketMode bucketMode) {
        this.bucketMode = bucketMode;
        if (this.bucketMode == BucketMode.BUCKET) {
            this.setTransferRate(this.transferRate / 1000 * 1000);
        }
        this.coverHolder.markDirty();
    }

    public BucketMode getBucketMode() {
        return this.bucketMode;
    }

    public ManualImportExportMode getManualImportExportMode() {
        return this.manualImportExportMode;
    }

    protected void setManualImportExportMode(ManualImportExportMode manualImportExportMode) {
        this.manualImportExportMode = manualImportExportMode;
        this.coverHolder.markDirty();
    }

    public void func_73660_a() {
        long timer = this.coverHolder.getOffsetTimer();
        if (this.isWorkingAllowed && this.fluidLeftToTransferLastSecond > 0) {
            this.fluidLeftToTransferLastSecond -= this.doTransferFluids(this.fluidLeftToTransferLastSecond);
        }
        if (timer % 20L == 0L) {
            this.fluidLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferFluids(int transferLimit) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        blockPos.func_189533_g((Vec3i)this.coverHolder.getPos()).func_189536_c(this.attachedSide);
        TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s((BlockPos)blockPos);
        blockPos.func_185344_t();
        IFluidHandler fluidHandler = tileEntity == null ? null : (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
        IFluidHandler myFluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide);
        if (fluidHandler == null || myFluidHandler == null) {
            return 0;
        }
        return this.doTransferFluidsInternal(myFluidHandler, fluidHandler, transferLimit);
    }

    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        if (this.pumpMode == PumpMode.IMPORT) {
            return GTFluidUtils.transferFluids(fluidHandler, myFluidHandler, transferLimit, this.fluidFilter::testFluidStack);
        }
        if (this.pumpMode == PumpMode.EXPORT) {
            return GTFluidUtils.transferFluids(myFluidHandler, fluidHandler, transferLimit, this.fluidFilter::testFluidStack);
        }
        return 0;
    }

    protected boolean checkInputFluid(FluidStack fluidStack) {
        return this.fluidFilter.testFluidStack(fluidStack);
    }

    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        return builder.build(this, player);
    }

    protected String getUITitle() {
        return "cover.pump.title";
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), GTValues.VN[this.tier]));
        primaryGroup.addWidget(new ClickButtonWidget(10, 20, 34, 18, "-100", data -> this.adjustTransferRate(data.isShiftClick ? -500 : -100)));
        primaryGroup.addWidget(new ClickButtonWidget(128, 20, 34, 18, "+100", data -> this.adjustTransferRate(data.isShiftClick ? 500 : 100)));
        primaryGroup.addWidget(new ClickButtonWidget(45, 20, 23, 18, "-10", data -> this.adjustTransferRate(data.isShiftClick ? -50 : -10)));
        primaryGroup.addWidget(new ClickButtonWidget(105, 20, 23, 18, "+10", data -> this.adjustTransferRate(data.isShiftClick ? 50 : 10)));
        primaryGroup.addWidget(new ClickButtonWidget(68, 20, 18, 18, "-1", data -> this.adjustTransferRate(data.isShiftClick ? -5 : -1)));
        primaryGroup.addWidget(new ClickButtonWidget(86, 20, 18, 18, "+1", data -> this.adjustTransferRate(data.isShiftClick ? 5 : 1)));
        primaryGroup.addWidget(new ImageWidget(10, 40, 120, 18, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(70, 49, "cover.pump.transfer_rate", 0xFFFFFF, () -> this.bucketMode == BucketMode.BUCKET ? Integer.toString(this.transferRate / 1000) : Integer.toString(this.transferRate)));
        primaryGroup.addWidget(new CycleButtonWidget(132, 40, 30, 18, BucketMode.class, this::getBucketMode, this::setBucketMode));
        primaryGroup.addWidget(new CycleButtonWidget(10, 63, 75, 18, PumpMode.class, this::getPumpMode, this::setPumpMode));
        primaryGroup.addWidget(new CycleButtonWidget(10, 160, 113, 20, ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        this.fluidFilter.initUI(88, primaryGroup::addWidget);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 266).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 184);
        return this.buildUI(builder, player);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public boolean shouldCoverInteractWithOutputside() {
        return true;
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.fluidFilter.getFilterInventory());
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.PUMP_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandlerWrapper == null || this.fluidHandlerWrapper.delegate != delegate) {
                this.fluidHandlerWrapper = new CoverableFluidHandlerWrapper(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74768_a("ManualImportExportMode", this.manualImportExportMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilter.serializeNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.pumpMode = PumpMode.values()[tagCompound.func_74762_e("PumpMode")];
        if (tagCompound.func_74764_b("AllowManualIO")) {
            ManualImportExportMode manualImportExportMode = this.manualImportExportMode = tagCompound.func_74767_n("AllowManualIO") ? ManualImportExportMode.FILTERED : ManualImportExportMode.DISABLED;
        }
        if (tagCompound.func_74764_b("FluidFilter")) {
            this.fluidFilter.deserializeNBT(tagCompound);
        } else {
            this.fluidFilter.deserializeNBT(tagCompound.func_74775_l("Filter"));
        }
        if (tagCompound.func_74764_b("WorkingAllowed")) {
            this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        }
        if (tagCompound.func_74764_b("ManualImportExportMode")) {
            this.manualImportExportMode = ManualImportExportMode.values()[tagCompound.func_74762_e("ManualImportExportMode")];
        }
    }

    private class CoverableFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public CoverableFluidHandlerWrapper(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (CoverPump.this.pumpMode == PumpMode.EXPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return 0;
            }
            if (!CoverPump.this.checkInputFluid(resource) && CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            if (!CoverPump.this.checkInputFluid(resource) && CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            FluidStack result = super.drain(maxDrain, false);
            if (!CoverPump.this.checkInputFluid(result) && CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                return null;
            }
            if (doDrain) {
                super.drain(maxDrain, true);
            }
            return result;
        }
    }

    public static enum BucketMode implements IStringSerializable
    {
        BUCKET("cover.bucket.mode.bucket"),
        MILLI_BUCKET("cover.bucket.mode.milli_bucket");

        public final String localeName;

        private BucketMode(String localeName) {
            this.localeName = localeName;
        }

        public String func_176610_l() {
            return this.localeName;
        }
    }

    public static enum PumpMode implements IStringSerializable
    {
        IMPORT("cover.pump.mode.import"),
        EXPORT("cover.pump.mode.export");

        public final String localeName;

        private PumpMode(String localeName) {
            this.localeName = localeName;
        }

        public String func_176610_l() {
            return this.localeName;
        }
    }
}

