/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.FluidFilterWrapper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class FluidFilterContainer
implements INBTSerializable<NBTTagCompound> {
    private final IDirtyNotifiable dirtyNotifiable;
    private final ItemStackHandler filterInventory;
    private final FluidFilterWrapper filterWrapper;

    public FluidFilterContainer(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
        this.filterWrapper = new FluidFilterWrapper(dirtyNotifiable);
        this.filterInventory = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return FilterTypeRegistry.getFluidFilterForStack(stack) != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onLoad() {
                FluidFilterContainer.this.onFilterSlotChange(false);
            }

            protected void onContentsChanged(int slot) {
                FluidFilterContainer.this.onFilterSlotChange(true);
            }
        };
    }

    public ItemStackHandler getFilterInventory() {
        return this.filterInventory;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.pump.fluid_filter.title", new Object[0]));
        widgetGroup.accept(new SlotWidget((IItemHandlerModifiable)this.filterInventory, 0, 10, y + 15).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        this.filterWrapper.initUI(y + 15, widgetGroup);
    }

    protected void onFilterSlotChange(boolean notify) {
        ItemStack filterStack = this.filterInventory.getStackInSlot(0);
        FluidFilter newFluidFilter = FilterTypeRegistry.getFluidFilterForStack(filterStack);
        FluidFilter currentFluidFilter = this.filterWrapper.getFluidFilter();
        if (newFluidFilter == null) {
            if (currentFluidFilter != null) {
                this.filterWrapper.setFluidFilter(null);
                if (notify) {
                    this.filterWrapper.onFilterInstanceChange();
                }
            }
        } else if (currentFluidFilter == null || newFluidFilter.getClass() != currentFluidFilter.getClass()) {
            this.filterWrapper.setFluidFilter(newFluidFilter);
            if (notify) {
                this.filterWrapper.onFilterInstanceChange();
            }
        }
    }

    public boolean testFluidStack(FluidStack fluidStack) {
        return this.filterWrapper.testFluidStack(fluidStack);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("FilterInventory", (NBTBase)this.filterInventory.serializeNBT());
        tagCompound.func_74757_a("IsBlacklist", this.filterWrapper.isBlacklistFilter());
        if (this.filterWrapper.getFluidFilter() != null) {
            NBTTagCompound filterInventory = new NBTTagCompound();
            this.filterWrapper.getFluidFilter().writeToNBT(filterInventory);
            tagCompound.func_74782_a("Filter", (NBTBase)filterInventory);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("FilterTypeInventory")) {
            this.filterInventory.deserializeNBT(tagCompound.func_74775_l("FilterTypeInventory"));
        } else {
            this.filterInventory.deserializeNBT(tagCompound.func_74775_l("FilterInventory"));
        }
        this.filterWrapper.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        if (this.filterWrapper.getFluidFilter() != null) {
            if (tagCompound.func_74764_b("FluidFilter")) {
                this.filterWrapper.getFluidFilter().readFromNBT(tagCompound);
            } else {
                NBTTagCompound filterInventory = tagCompound.func_74775_l("Filter");
                this.filterWrapper.getFluidFilter().readFromNBT(filterInventory);
            }
        }
    }
}

