/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.api.util.ItemStackKey;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.WidgetGroupItemFilter;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;

public class ItemFilterWrapper {
    private static final Object MATCH_RESULT_TRUE = new Object();
    private final IDirtyNotifiable dirtyNotifiable;
    private boolean isBlacklistFilter = false;
    private int maxStackSize = 1;
    private ItemFilter currentItemFilter;
    private Runnable onFilterInstanceChange;

    public ItemFilterWrapper(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        ServerWidgetGroup blacklistButton = new ServerWidgetGroup(() -> this.getItemFilter() != null);
        blacklistButton.addWidget(new ToggleButtonWidget(146, y, 20, 20, GuiTextures.BUTTON_BLACKLIST, this::isBlacklistFilter, this::setBlacklistFilter).setTooltipText("cover.filter.blacklist"));
        widgetGroup.accept(blacklistButton);
        widgetGroup.accept(new WidgetGroupItemFilter(y, this::getItemFilter));
    }

    public void setItemFilter(ItemFilter itemFilter) {
        this.currentItemFilter = itemFilter;
        if (this.currentItemFilter != null) {
            this.currentItemFilter.setDirtyNotifiable(this.dirtyNotifiable);
        }
        if (this.onFilterInstanceChange != null) {
            this.onFilterInstanceChange.run();
        }
    }

    public ItemFilter getItemFilter() {
        return this.currentItemFilter;
    }

    public void setOnFilterInstanceChange(Runnable onFilterInstanceChange) {
        this.onFilterInstanceChange = onFilterInstanceChange;
    }

    public void onFilterInstanceChange() {
        if (this.currentItemFilter != null) {
            this.currentItemFilter.setMaxStackSize(this.getInternalMaxStackSize());
        }
        this.dirtyNotifiable.markAsDirty();
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        this.onFilterInstanceChange();
        this.dirtyNotifiable.markAsDirty();
    }

    public void setBlacklistFilter(boolean blacklistFilter) {
        this.isBlacklistFilter = blacklistFilter;
        this.onFilterInstanceChange();
        this.dirtyNotifiable.markAsDirty();
    }

    public boolean isBlacklistFilter() {
        return this.isBlacklistFilter;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    private int getInternalMaxStackSize() {
        if (this.isBlacklistFilter()) {
            return 1;
        }
        return this.getMaxStackSize();
    }

    public boolean showGlobalTransferLimitSlider() {
        return this.isBlacklistFilter() || this.currentItemFilter == null || this.currentItemFilter.showGlobalTransferLimitSlider();
    }

    public int getSlotTransferLimit(Object matchSlot, Set<ItemStackKey> matchedStacks, int globalTransferLimit) {
        if (this.isBlacklistFilter() || this.currentItemFilter == null) {
            return globalTransferLimit;
        }
        return this.currentItemFilter.getSlotTransferLimit(matchSlot, matchedStacks, globalTransferLimit);
    }

    public Object matchItemStack(ItemStack itemStack) {
        Object originalResult = this.currentItemFilter == null ? MATCH_RESULT_TRUE : this.currentItemFilter.matchItemStack(itemStack);
        if (this.isBlacklistFilter()) {
            originalResult = originalResult == null ? MATCH_RESULT_TRUE : null;
        }
        return originalResult;
    }

    public boolean testItemStack(ItemStack itemStack) {
        return this.matchItemStack(itemStack) != null;
    }
}

