/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes;

import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixHelper;
import gregtech.common.datafix.fixes.metablockid.PostGraniteMetaBlockIdFixer;
import gregtech.common.datafix.fixes.metablockid.WorldDataHooks;
import gregtech.common.datafix.util.RemappedBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Fix1MetaBlockIdSystem
implements IFixableData {
    public Fix1MetaBlockIdSystem() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        if (WorldDataHooks.isFixerUnavailable()) {
            return compound;
        }
        String blockResLoc = compound.func_74779_i("id");
        int index = MetaBlockIdFixHelper.getCompressedIndexFromResLoc(blockResLoc);
        if (index != -1) {
            RemappedBlock remapped = ((PostGraniteMetaBlockIdFixer)WorldDataHooks.getMetaBlockIdFixer()).remapCompressedPostGraniteToNew(index, compound.func_74765_d("Damage"));
            compound.func_74778_a("id", "gregtech:meta_block_compressed_" + remapped.id);
            compound.func_74777_a("Damage", remapped.data);
            return compound;
        }
        index = MetaBlockIdFixHelper.getSurfRockIndexFromResLoc(blockResLoc);
        if (index != -1) {
            RemappedBlock remapped = ((PostGraniteMetaBlockIdFixer)WorldDataHooks.getMetaBlockIdFixer()).remapSurfRockToNew(index, compound.func_74765_d("Damage"));
            compound.func_74778_a("id", "gregtech:meta_block_surface_rock_" + remapped.id);
            compound.func_74777_a("Damage", remapped.data);
        }
        return compound;
    }

    @SubscribeEvent
    public void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String regName = mapping.key.func_110623_a();
            if (!regName.startsWith("compressed_") && !regName.startsWith("surface_rock_")) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String regName = mapping.key.func_110623_a();
            if (!regName.startsWith("compressed_") && !regName.startsWith("surface_rock_")) continue;
            mapping.ignore();
        }
    }
}

