/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import gregtech.api.util.Version;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixHelper;
import gregtech.common.datafix.fixes.metablockid.PostGraniteMetaBlockIdFixer;
import gregtech.common.datafix.fixes.metablockid.PreGraniteMetaBlockIdFixer;
import net.minecraft.nbt.NBTTagCompound;

public interface MetaBlockIdFixer {
    public static final MetaBlockIdFixer NOOP = new Noop();

    public static MetaBlockIdFixer create(Version prevSaveVersion, NBTTagCompound fmlTag) {
        if (prevSaveVersion.compareTo(MetaBlockIdFixHelper.V1_10_5) < 0) {
            return PreGraniteMetaBlockIdFixer.generate(fmlTag);
        }
        if (prevSaveVersion.compareTo(MetaBlockIdFixHelper.V1_15_0) < 0) {
            return PostGraniteMetaBlockIdFixer.generate(fmlTag);
        }
        return NOOP;
    }

    public int getFallbackDataVersion();

    public NBTTagCompound serialize();

    public static MetaBlockIdFixer deserialize(NBTTagCompound tag) {
        if (tag.func_150297_b("FallbackVersion", 3)) {
            int fallbackVersion = tag.func_74762_e("FallbackVersion");
            switch (fallbackVersion) {
                case -1: {
                    return PreGraniteMetaBlockIdFixer.deserialize(tag);
                }
                case 0: {
                    return PostGraniteMetaBlockIdFixer.deserialize(tag);
                }
            }
            throw new IllegalStateException("Bad GregTech fallback data version: " + fallbackVersion);
        }
        return NOOP;
    }

    public static class Noop
    implements MetaBlockIdFixer {
        private Noop() {
        }

        @Override
        public int getFallbackDataVersion() {
            return 1;
        }

        @Override
        public NBTTagCompound serialize() {
            return new NBTTagCompound();
        }
    }
}

