/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixHelper;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdRemapCache;
import gregtech.common.datafix.fixes.metablockid.PostGraniteMetaBlockIdFixer;
import gregtech.common.datafix.util.RemappedBlock;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PreGraniteMetaBlockIdFixer
extends PostGraniteMetaBlockIdFixer {
    private static final int GRANITE_ID = Material.MATERIAL_REGISTRY.getIDForObject(Materials.Granite);

    public PreGraniteMetaBlockIdFixer(MetaBlockIdRemapCache remapCacheCompressed, MetaBlockIdRemapCache remapCacheSurfRock) {
        super(remapCacheCompressed, remapCacheSurfRock);
    }

    public static PreGraniteMetaBlockIdFixer generate(NBTTagCompound fmlTag) {
        NBTTagList blockRegistryTag = MetaBlockIdFixHelper.getBlockRegistryTag(fmlTag);
        if (blockRegistryTag == null) {
            throw new IllegalStateException("Block registry is not serialized in level data!");
        }
        MetaBlockIdRemapCache[] remapCaches = MetaBlockIdRemapCache.generate(blockRegistryTag, new MetaBlockIdRemapCache.Spec("meta_block_compressed_", MetaBlockIdFixHelper::getCompressedIndexFromResLoc, true), new MetaBlockIdRemapCache.Spec("meta_block_surface_rock_", MetaBlockIdFixHelper::getSurfRockIndexFromResLoc, false));
        return new PreGraniteMetaBlockIdFixer(remapCaches[0], remapCaches[1]);
    }

    @Override
    public int getFallbackDataVersion() {
        return -1;
    }

    @Nullable
    public RemappedBlock remapCompressedPreGraniteToPost(int index, int data) {
        int matId = PreGraniteMetaBlockIdFixer.getTableOldAllocCompressed().get(index)[data];
        if (matId >= GRANITE_ID) {
            if (data == 15) {
                return new RemappedBlock(index + 1, 0);
            }
            return new RemappedBlock(index, (short)(data + 1));
        }
        return null;
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound tag = super.serialize();
        tag.func_74768_a("FallbackVersion", -1);
        return tag;
    }

    public static PreGraniteMetaBlockIdFixer deserialize(NBTTagCompound tag) {
        return new PreGraniteMetaBlockIdFixer(MetaBlockIdRemapCache.deserialize("meta_block_compressed_", tag.func_74775_l("RemapCacheCompressed")), MetaBlockIdRemapCache.deserialize("meta_block_surface_rock_", tag.func_74775_l("RemapCacheSurfaceRock")));
    }
}

