/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import gregtech.GregTechVersion;
import gregtech.api.util.GTLog;
import gregtech.api.util.Version;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixHelper;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.relauncher.Side;

public class WorldDataHooks {
    private static final String MAP_STORAGE_NAME = "gregtech_data";
    private static final String KEY_META_BLOCK_ID_FIXER = "MetaBlockIdFixer";
    @Nullable
    private static MetaBlockIdFixer metaBlockIdFixer = null;

    private WorldDataHooks() {
    }

    public static boolean isFixerUnavailable() {
        return metaBlockIdFixer == null;
    }

    public static MetaBlockIdFixer getMetaBlockIdFixer() {
        return Objects.requireNonNull(metaBlockIdFixer);
    }

    public static void onWorldLoad(SaveHandler saveHandler, NBTTagCompound levelTag) {
        NBTTagCompound fmlTag;
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        metaBlockIdFixer = null;
        boolean firstTimeFixing = false;
        File mapStorageFile = saveHandler.func_75758_b(MAP_STORAGE_NAME);
        NBTTagCompound wsdDataTag = null;
        boolean wsdNeedsWrite = true;
        if (mapStorageFile.exists()) {
            try (FileInputStream mapStorageIn = new FileInputStream(mapStorageFile);){
                wsdDataTag = CompressedStreamTools.func_74796_a((InputStream)mapStorageIn).func_74775_l("data");
                if (wsdDataTag.func_150297_b(KEY_META_BLOCK_ID_FIXER, 10)) {
                    metaBlockIdFixer = MetaBlockIdFixer.deserialize(wsdDataTag.func_74775_l(KEY_META_BLOCK_ID_FIXER));
                    GTLog.logger.info("Using fallback data version {} from WSD", (Object)metaBlockIdFixer.getFallbackDataVersion());
                    wsdNeedsWrite = false;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read GregTech world-saved data!", e);
            }
        }
        if (metaBlockIdFixer == null && levelTag.func_150297_b("FML", 10) && (fmlTag = levelTag.func_74775_l("FML")).func_150297_b("ModList", 9)) {
            NBTTagList modListTag = fmlTag.func_150295_c("ModList", 10);
            for (int i = 0; i < modListTag.func_74745_c(); ++i) {
                NBTTagCompound modEntryTag = modListTag.func_150305_b(i);
                if (!modEntryTag.func_74779_i("ModId").equals("gregtech")) continue;
                Version prevSaveVersion = Version.parse(modEntryTag.func_74779_i("ModVersion"));
                metaBlockIdFixer = MetaBlockIdFixer.create(prevSaveVersion, fmlTag);
                GTLog.logger.info("Using fallback data version {} from previous GregTech version {}", (Object)metaBlockIdFixer.getFallbackDataVersion(), (Object)prevSaveVersion);
                if (metaBlockIdFixer.getFallbackDataVersion() >= 1) continue;
                firstTimeFixing = true;
            }
        }
        if (metaBlockIdFixer == null) {
            metaBlockIdFixer = MetaBlockIdFixer.NOOP;
            GTLog.logger.info("Using fallback data version 1 by default");
        }
        if (wsdNeedsWrite) {
            if (wsdDataTag == null) {
                wsdDataTag = new NBTTagCompound();
            }
            wsdDataTag.func_74782_a(KEY_META_BLOCK_ID_FIXER, (NBTBase)metaBlockIdFixer.serialize());
            NBTTagCompound wsdTag = new NBTTagCompound();
            wsdTag.func_74782_a("data", (NBTBase)wsdDataTag);
            try (FileOutputStream mapStorageOut = new FileOutputStream(mapStorageFile);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)wsdTag, (OutputStream)mapStorageOut);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write GregTech world-saved data!", e);
            }
        }
        if (firstTimeFixing) {
            WorldDataHooks.promptWorldBackup(metaBlockIdFixer.getFallbackDataVersion());
        }
    }

    public static void promptWorldBackup(int prevDataVersion) {
        String text = "GregTech detected a required registry remapping!\n\nUpdating from before " + TextFormatting.AQUA + (prevDataVersion == -1 ? MetaBlockIdFixHelper.V1_10_5 : MetaBlockIdFixHelper.V1_15_0) + TextFormatting.RESET + " to " + TextFormatting.AQUA + GregTechVersion.VERSION.toString(3) + TextFormatting.RESET + ".\nIt is " + TextFormatting.UNDERLINE + "strongly" + TextFormatting.RESET + " recommended that you perform a backup. Create backup?";
        if (StartupQuery.confirm((String)text)) {
            try {
                GTLog.logger.info("Creating world backup before starting registry remapping...");
                ZipperUtil.backupWorld();
            }
            catch (IOException e) {
                GTLog.logger.error((Object)e);
                StartupQuery.notify((String)"Encountered an error while creating the backup!\nSee the game log for more details.");
                StartupQuery.abort();
            }
        } else {
            String reconfirm = "No backup will be created. Proceed with the remapping without a backup?";
            if (!StartupQuery.confirm((String)reconfirm)) {
                StartupQuery.abort();
            }
        }
    }

    public static int getFallbackModVersion(String modId) {
        return metaBlockIdFixer != null && modId.equals("gregtech") ? metaBlockIdFixer.getFallbackDataVersion() : -1;
    }
}

