/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import com.google.common.base.Preconditions;
import gregtech.api.gui.igredient.IRecipeTransferHandlerWidget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.common.metatileentities.storage.CraftingRecipeResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class CraftingSlotWidget
extends SlotWidget
implements IRecipeTransferHandlerWidget {
    private CraftingRecipeResolver recipeResolver;
    private boolean canTakeStack = false;

    public CraftingSlotWidget(CraftingRecipeResolver recipeResolver, int slotIndex, int xPosition, int yPosition) {
        super(CraftingSlotWidget.createInventory(recipeResolver), slotIndex, xPosition, yPosition, true, false);
        this.recipeResolver = recipeResolver;
    }

    private static IInventory createInventory(CraftingRecipeResolver resolver) {
        return resolver == null ? new InventoryCraftResult() : resolver.getCraftingResultInventory();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            HashMap<Integer, ItemStack> ingredients = new HashMap<Integer, ItemStack>();
            int ingredientAmount = buffer.func_150792_a();
            try {
                for (int i = 0; i < ingredientAmount; ++i) {
                    ingredients.put(buffer.func_150792_a(), buffer.func_150791_c());
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this.recipeResolver.setCraftingGrid(ingredients);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.recipeResolver == null) {
            return;
        }
        boolean isRecipeValid = this.recipeResolver.checkRecipeValid();
        if (isRecipeValid != this.canTakeStack) {
            this.canTakeStack = isRecipeValid;
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.canTakeStack));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.canTakeStack = buffer.readBoolean();
        }
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canTakeStack(EntityPlayer player) {
        if (!super.canTakeStack(player)) {
            return false;
        }
        if (this.recipeResolver == null) {
            return this.canTakeStack;
        }
        return this.recipeResolver.checkRecipeValid();
    }

    @Override
    public ItemStack onItemTake(EntityPlayer thePlayer, ItemStack stack, boolean simulate) {
        if (this.recipeResolver == null) {
            return this.canTakeStack ? stack : ItemStack.field_190927_a;
        }
        if (!this.recipeResolver.checkRecipeValid()) {
            return ItemStack.field_190927_a;
        }
        this.recipeResolver.handleItemCraft(stack, thePlayer, simulate);
        if (simulate) {
            return stack;
        }
        this.recipeResolver.performRecipe(thePlayer);
        this.recipeResolver.refreshOutputSlot();
        this.gui.entityPlayer.field_71070_bA.func_75142_b();
        this.uiAccess.sendSlotUpdate(this);
        return stack;
    }

    @Override
    public String transferRecipe(ModularUIContainer container, Map<Integer, IGuiIngredient<ItemStack>> ingredients, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        ingredients.values().removeIf(it -> !it.isInput());
        this.writeClientAction(1, buf -> {
            buf.func_150787_b(ingredients.size());
            for (Map.Entry entry : ingredients.entrySet()) {
                buf.func_150787_b(((Integer)entry.getKey()).intValue());
                ItemStack itemStack = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                Preconditions.checkNotNull((Object)itemStack);
                buf.func_150788_a(itemStack);
            }
        });
        return null;
    }
}

