/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.gui.widget.ItemListGridWidget;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.IItemList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class ItemListSlotWidget
extends Widget {
    private final ItemListGridWidget gridWidget;
    private final int index;

    ItemListSlotWidget(int x, int y, ItemListGridWidget gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    public String formatItemAmount(int itemAmount) {
        return Integer.toString(itemAmount);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, context);
        Position position = this.getPosition();
        GuiTextures.SLOT.draw(position.x, position.y, 18, 18);
        IItemInfo itemInfo = this.gridWidget.getItemInfoAt(this.index);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (itemInfo != null) {
            ItemStack itemStack = itemInfo.getItemStackKey().getItemStackRaw();
            String itemAmountStr = this.formatItemAmount(itemInfo.getTotalItemAmount());
            ItemListSlotWidget.drawItemStack(itemStack, stackX, stackY, null);
            this.drawStringFixedCorner(itemAmountStr, stackX + 17, stackY + 17, 0xFFFFFF, true, 0.5f);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ItemListSlotWidget.drawSelectionOverlay(stackX, stackY, 16, 16);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        IItemInfo itemInfo = this.gridWidget.getItemInfoAt(this.index);
        if (itemInfo != null && this.isMouseOverElement(mouseX, mouseY)) {
            ItemStack itemStack = itemInfo.getItemStackKey().getItemStackRaw();
            List<String> tooltip = ItemListSlotWidget.getItemToolTip(itemStack);
            int totalItemStored = itemInfo.getTotalItemAmount();
            String itemStoredText = I18n.func_135052_a((String)"gregtech.item_list.item_stored", (Object[])new Object[]{totalItemStored});
            tooltip.add(TextFormatting.GRAY + itemStoredText);
            this.drawHoveringText(itemStack, tooltip, -1, mouseX, mouseY);
        }
    }

    private void setCreativeHeldItem(ItemStack itemStack) {
        InventoryPlayer inventory = this.gui.entityPlayer.field_71071_by;
        if (!itemStack.func_190926_b() && inventory.func_70445_o().func_190926_b()) {
            itemStack.func_190920_e(itemStack.func_77976_d());
            inventory.func_70437_b(itemStack);
        }
    }

    private int getAmountToTake(ItemStack itemStack, int maxAmount, int button) {
        int maxStackSize = Math.min(itemStack.func_77976_d(), maxAmount);
        return button == 0 ? maxStackSize : (maxStackSize >= 2 ? maxStackSize / 2 : 1);
    }

    private boolean insertHeldItemStack(int button, boolean isClient) {
        int amountToInsert;
        InventoryPlayer inventory = this.gui.entityPlayer.field_71071_by;
        int n = amountToInsert = button == 1 ? 1 : Integer.MAX_VALUE;
        if (!inventory.func_70445_o().func_190926_b()) {
            if (!isClient) {
                ItemStack heldItemStack = inventory.func_70445_o();
                IItemList itemList = this.gridWidget.getItemList();
                int amountInserted = itemList.insertItem(new ItemStackKey(heldItemStack), Math.min(heldItemStack.func_190916_E(), amountToInsert), false, IItemList.InsertMode.LOWEST_PRIORITY);
                heldItemStack.func_190918_g(amountInserted);
                this.uiAccess.sendHeldItemUpdate();
                this.gui.entityPlayer.field_71070_bA.func_75142_b();
                return amountInserted > 0;
            }
            inventory.func_70445_o().func_190918_g(amountToInsert);
            return true;
        }
        return false;
    }

    private void extractItemStack(ItemStackKey itemStackKey, int amount, boolean isClient) {
        InventoryPlayer inventory = this.gui.entityPlayer.field_71071_by;
        if (inventory.func_70445_o().func_190926_b()) {
            if (!isClient) {
                IItemList itemList = this.gridWidget.getItemList();
                int amountExtracted = itemList.extractItem(itemStackKey, amount, false);
                if (amountExtracted > 0) {
                    ItemStack resultStack = itemStackKey.getItemStack();
                    resultStack.func_190920_e(amountExtracted);
                    inventory.func_70437_b(resultStack);
                }
                this.uiAccess.sendHeldItemUpdate();
            } else {
                ItemStack itemStack = itemStackKey.getItemStack();
                itemStack.func_190920_e(amount);
                inventory.func_70437_b(itemStack);
            }
        }
    }

    private void handleMouseClick(@Nullable IItemInfo itemInfo, int button, boolean isClient) {
        if (button == 2) {
            if (itemInfo != null && this.gui.entityPlayer.func_184812_l_()) {
                ItemStack itemStack = itemInfo.getItemStackKey().getItemStack();
                this.setCreativeHeldItem(itemStack);
            }
        } else if (button == 0 || button == 1) {
            if (this.insertHeldItemStack(button, isClient) || !this.gui.entityPlayer.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            if (itemInfo != null) {
                ItemStack itemStack = itemInfo.getItemStackKey().getItemStack();
                int extractAmount = this.getAmountToTake(itemStack, itemInfo.getTotalItemAmount(), button);
                this.extractItemStack(itemInfo.getItemStackKey(), extractAmount, isClient);
            }
        }
    }

    private void handleSelfShiftClick(IItemInfo itemInfo) {
        ItemStack itemStack = itemInfo.getItemStackKey().getItemStack();
        itemStack.func_190920_e(itemStack.func_77976_d());
        int currentStackSize = itemStack.func_190916_E();
        this.uiAccess.attemptMergeStack(itemStack, true, true);
        int amountToExtract = Math.min(currentStackSize - itemStack.func_190916_E(), itemInfo.getTotalItemAmount());
        if (amountToExtract > 0) {
            int extracted = this.gridWidget.getItemList().extractItem(itemInfo.getItemStackKey(), amountToExtract, false);
            ItemStack resultStack = itemInfo.getItemStackKey().getItemStack();
            resultStack.func_190920_e(extracted);
            if (!resultStack.func_190926_b()) {
                this.uiAccess.attemptMergeStack(resultStack, true, false);
                this.gui.entityPlayer.field_71070_bA.func_75142_b();
                if (!resultStack.func_190926_b()) {
                    this.gui.entityPlayer.func_146097_a(resultStack, false, false);
                }
            }
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            try {
                ItemStack itemStack = buffer.func_150791_c();
                int button = buffer.func_150792_a();
                IItemInfo itemInfo = itemStack.func_190926_b() ? null : this.gridWidget.getItemList().getItemInfo(new ItemStackKey(itemStack));
                this.handleMouseClick(itemInfo, button, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (id == 2) {
            try {
                ItemStack itemStack = buffer.func_150791_c();
                IItemInfo itemInfo = this.gridWidget.getItemList().getItemInfo(new ItemStackKey(itemStack));
                if (itemInfo != null) {
                    this.handleSelfShiftClick(itemInfo);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void dispatchMouseClick(int button) {
        IItemInfo itemInfo = this.gridWidget.getItemInfoAt(this.index);
        this.handleMouseClick(itemInfo, button, true);
        ItemStack itemStack = itemInfo == null ? ItemStack.field_190927_a : itemInfo.getItemStackKey().getItemStack();
        this.writeClientAction(1, buf -> {
            buf.func_150788_a(itemStack);
            buf.func_150787_b(button);
        });
    }

    private void dispatchSelfShiftClick() {
        IItemInfo itemInfo = this.gridWidget.getItemInfoAt(this.index);
        if (itemInfo != null) {
            this.writeClientAction(2, buf -> buf.func_150788_a(itemInfo.getItemStackKey().getItemStackRaw()));
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            boolean shiftClick;
            boolean bl = shiftClick = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (!shiftClick) {
                this.dispatchMouseClick(button);
            } else {
                this.dispatchSelfShiftClick();
            }
            return true;
        }
        return false;
    }
}

