/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource;

import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.itemsource.ItemSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NetworkItemInfo
implements IItemInfo {
    private final ItemStackKey itemStackKey;
    private int totalItemAmount = 0;
    private Map<ItemSource, Integer> inventories = new ConcurrentHashMap<ItemSource, Integer>();

    public NetworkItemInfo(ItemStackKey itemStackKey) {
        this.itemStackKey = itemStackKey;
    }

    @Override
    public int getTotalItemAmount() {
        return this.totalItemAmount;
    }

    @Override
    public ItemStackKey getItemStackKey() {
        return this.itemStackKey;
    }

    int extractItem(int amount, boolean simulate) {
        int amountToExtract = amount;
        for (ItemSource itemSource : this.inventories.keySet()) {
            if ((amountToExtract -= itemSource.extractItem(this.itemStackKey, amountToExtract, simulate)) == 0) break;
        }
        int extracted = amount - amountToExtract;
        if (!simulate && extracted > 0) {
            this.recomputeItemAmount();
        }
        return extracted;
    }

    boolean addInventory(ItemSource inventory, int amount) {
        if (this.inventories.getOrDefault(inventory, 0) != amount) {
            this.inventories.put(inventory, amount);
            return this.recomputeItemAmount();
        }
        return false;
    }

    boolean removeInventory(ItemSource inventory) {
        if (this.inventories.containsKey(inventory)) {
            this.inventories.remove(inventory);
            return this.recomputeItemAmount();
        }
        return false;
    }

    private boolean recomputeItemAmount() {
        int oldTotalItemAmount = this.totalItemAmount;
        this.totalItemAmount = this.inventories.values().stream().mapToInt(Integer::intValue).sum();
        return this.totalItemAmount != oldTotalItemAmount;
    }
}

