/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource.sources;

import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.itemsource.ItemSource;
import gregtech.common.pipelike.inventory.network.UpdateResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public abstract class InventoryItemSource
extends ItemSource {
    protected final World world;
    protected final int priority;
    private Runnable invalidationCallback = null;
    private ItemSource.StoredItemsChangeCallback changeCallback = null;
    protected IItemHandler itemHandler = EmptyHandler.INSTANCE;
    private Map<ItemStackKey, Integer> itemStackByAmountMap = new HashMap<ItemStackKey, Integer>();
    private long lastItemHandlerUpdateTick = -1L;
    private long lastStoredItemListUpdateTick = -1L;
    private boolean cachedRefreshResult = false;

    public InventoryItemSource(World world, int priority) {
        this.world = world;
        this.priority = priority;
    }

    public static InventoryItemSource direct(World world, final IItemHandler itemHandler1, int priority) {
        return new InventoryItemSource(world, priority){

            @Override
            protected IItemHandler computeItemHandler() {
                return itemHandler1;
            }
        };
    }

    protected abstract IItemHandler computeItemHandler();

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setInvalidationCallback(Runnable invalidatedRunnable) {
        this.invalidationCallback = invalidatedRunnable;
    }

    @Override
    public void setStoredItemsChangeCallback(ItemSource.StoredItemsChangeCallback callback) {
        this.changeCallback = callback;
    }

    private boolean refreshItemHandler(boolean simulated) {
        this.lastItemHandlerUpdateTick = this.world.func_82737_E();
        IItemHandler newItemHandler = this.computeItemHandler();
        if (newItemHandler == null) {
            if (!simulated && this.invalidationCallback != null) {
                this.invalidationCallback.run();
            }
            this.cachedRefreshResult = false;
            return false;
        }
        if (!newItemHandler.equals(this.itemHandler) || newItemHandler.getSlots() != this.itemHandler.getSlots()) {
            this.itemHandler = newItemHandler;
            if (!simulated) {
                this.recomputeItemStackCount();
            }
            this.cachedRefreshResult = false;
            return false;
        }
        this.cachedRefreshResult = true;
        return true;
    }

    @Override
    public UpdateResult update() {
        long currentTick = this.world.func_82737_E();
        if (currentTick - this.lastStoredItemListUpdateTick >= 20L) {
            return this.recomputeItemStackCount() ? UpdateResult.CHANGED : UpdateResult.STANDBY;
        }
        return UpdateResult.STANDBY;
    }

    private boolean checkItemHandlerValid(boolean simulated) {
        long currentUpdateTick = this.world.func_82737_E();
        if (currentUpdateTick != this.lastItemHandlerUpdateTick) {
            return this.refreshItemHandler(simulated);
        }
        return this.cachedRefreshResult;
    }

    @Override
    public int insertItem(ItemStackKey itemStackKey, int amount, boolean simulate) {
        if (!this.checkItemHandlerValid(simulate)) {
            return 0;
        }
        int itemsInserted = 0;
        ItemStack itemStack = itemStackKey.getItemStack();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemStack.func_190920_e(amount - itemsInserted);
            ItemStack remainderStack = this.itemHandler.insertItem(i, itemStack, simulate);
            if ((itemsInserted += itemStack.func_190916_E() - remainderStack.func_190916_E()) == amount) break;
        }
        if (itemsInserted > 0 && !simulate) {
            this.recomputeItemStackCount();
        }
        return itemsInserted;
    }

    @Override
    public int extractItem(ItemStackKey itemStackKey, int amount, boolean simulate) {
        if (!this.checkItemHandlerValid(simulate)) {
            return 0;
        }
        int itemsExtracted = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !itemStackKey.isItemStackEqual(stackInSlot)) continue;
            ItemStack extractedStack = this.itemHandler.extractItem(i, amount - itemsExtracted, simulate);
            if (!extractedStack.func_190926_b()) {
                itemsExtracted += extractedStack.func_190916_E();
            }
            if (itemsExtracted == amount) break;
        }
        if (itemsExtracted > 0 && !simulate) {
            this.recomputeItemStackCount();
        }
        return itemsExtracted;
    }

    @Override
    public Map<ItemStackKey, Integer> getStoredItems() {
        return Collections.unmodifiableMap(this.itemStackByAmountMap);
    }

    private boolean recomputeItemStackCount() {
        if (!this.checkItemHandlerValid(false)) {
            return false;
        }
        this.lastStoredItemListUpdateTick = this.world.func_82737_E();
        HashMap<ItemStackKey, Integer> amountMap = new HashMap<ItemStackKey, Integer>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            ItemStackKey stackKey = new ItemStackKey(itemStack);
            amountMap.put(stackKey, amountMap.getOrDefault(stackKey, 0) + itemStack.func_190916_E());
        }
        if (amountMap.equals(this.itemStackByAmountMap)) {
            return false;
        }
        HashSet<ItemStackKey> removedItems = new HashSet<ItemStackKey>(this.itemStackByAmountMap.keySet());
        removedItems.removeAll(amountMap.keySet());
        this.itemStackByAmountMap = amountMap;
        if (this.changeCallback != null) {
            this.changeCallback.onStoredItemsUpdated(amountMap, removedItems);
        }
        return true;
    }
}

