/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.metaitem.ElectricStats;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBubble;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorLogicRebreather
implements IArmorLogic {
    private final int energyUsagePerTick;
    @SideOnly(value=Side.CLIENT)
    private ModelBiped armorModel;

    public ArmorLogicRebreather(int energyUsagePerTick) {
        this.energyUsagePerTick = energyUsagePerTick;
    }

    @SideOnly(value=Side.CLIENT)
    private ModelBiped getArmorModel() {
        if (this.armorModel == null) {
            this.armorModel = new ModelBiped(1.0f, 0.0f, 32, 32);
            this.armorModel.field_178720_f.field_78807_k = true;
            ModelRenderer bipedHead = this.armorModel.field_78116_c;
            bipedHead.field_78804_l.add(new ModelBox(bipedHead, 0, 16, -2.0f, -6.0f, 4.0f, 4, 4, 4, 0.0f));
        }
        return this.armorModel;
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public void addToolComponents(ArmorMetaItem.ArmorMetaValueItem metaValueItem) {
        metaValueItem.addStats(ElectricStats.createElectricItem(360000L, 1L));
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem.getCharge() >= (long)this.energyUsagePerTick) {
            if (player.func_70055_a(Material.field_151586_h) && world.field_72995_K && world.func_82737_E() % 20L == 0L) {
                Vec3d pos = player.func_174791_d().func_178787_e(new Vec3d(0.0, (double)player.func_70047_e(), 0.0));
                Particle particle = new ParticleBubble.Factory().func_178902_a(0, world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                particle.func_187114_a(Integer.MAX_VALUE);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
            if (player.func_70055_a(Material.field_151586_h) && !player.func_70644_a(MobEffects.field_76427_o) && player.func_70086_ai() < 300 && this.drainActivationEnergy(electricItem)) {
                player.func_70050_g(Math.min(player.func_70086_ai() + 1, 300));
            }
        }
    }

    private boolean drainActivationEnergy(IElectricItem electricItem) {
        return electricItem.discharge(this.energyUsagePerTick, electricItem.getTier(), true, false, false) >= (long)this.energyUsagePerTick;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack itemStack, DamageSource source, int damage, EntityEquipmentSlot equipmentSlot) {
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        boolean isActive = electricItem.getCharge() >= (long)this.energyUsagePerTick && entity.func_70055_a(Material.field_151586_h);
        String textureName = isActive ? "rebreather_active.png" : "rebreather.png";
        return "gregtech:textures/models/armor/" + textureName;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        return this.getArmorModel();
    }
}

