/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.common.items.behaviors.AbstractUsableBehaviour;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ColorSprayBehaviour
extends AbstractUsableBehaviour {
    private final ItemStack empty;
    private final EnumDyeColor color;

    public ColorSprayBehaviour(ItemStack empty, int totalUses, int color) {
        super(totalUses);
        this.empty = empty;
        this.color = EnumDyeColor.values()[color];
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!this.tryPaintBlock(world, pos, side)) {
            return EnumActionResult.PASS;
        }
        this.useItemDurability(player, hand, stack, this.empty.func_77946_l());
        return EnumActionResult.SUCCESS;
    }

    private boolean tryPaintBlock(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return block.recolorBlock(world, pos, side, this.color) || this.tryPaintSpecialBlock(world, pos, block);
    }

    private boolean tryPaintSpecialBlock(World world, BlockPos pos, Block block) {
        if (block == Blocks.field_150359_w) {
            IBlockState newBlockState = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.color);
            world.func_175656_a(pos, newBlockState);
            return true;
        }
        if (block == Blocks.field_150410_aZ) {
            IBlockState newBlockState = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)this.color);
            world.func_175656_a(pos, newBlockState);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        int remainingUses = this.getUsesLeft(itemStack);
        lines.add(I18n.func_135052_a((String)("behaviour.paintspray." + this.color.func_176762_d() + ".tooltip"), (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
    }
}

