/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.VoidFluidHandlerItemStack;
import gregtech.api.items.IToolItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PlungerBehaviour
implements IItemBehaviour,
IItemCapabilityProvider {
    public final int cost;

    public PlungerBehaviour(int cost) {
        this.cost = cost;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IFluidHandler handlerToRemoveFrom;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return EnumActionResult.PASS;
        }
        IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        if (fluidHandler == null) {
            return EnumActionResult.PASS;
        }
        ItemStack toolStack = player.func_184586_b(hand);
        boolean isShiftClick = player.func_70093_af();
        IFluidHandler iFluidHandler = isShiftClick ? (fluidHandler instanceof FluidHandlerProxy ? ((FluidHandlerProxy)fluidHandler).input : null) : (handlerToRemoveFrom = fluidHandler instanceof FluidHandlerProxy ? ((FluidHandlerProxy)fluidHandler).output : fluidHandler);
        if (handlerToRemoveFrom != null && GTUtility.doDamageItem(toolStack, this.cost, false)) {
            if (!world.field_72995_K) {
                int amountOfFluid;
                FluidStack drainStack = handlerToRemoveFrom.drain(1000, true);
                int n = amountOfFluid = drainStack == null ? 0 : drainStack.amount;
                if (amountOfFluid > 0) {
                    player.func_184185_a(SoundEvents.field_187886_fs, 1.0f, (float)amountOfFluid / 1000.0f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.addAll(Arrays.asList(I18n.func_135052_a((String)"behavior.plunger.description", (Object[])new Object[0]).split("/n")));
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack itemStack) {
        return new VoidFluidHandlerItemStack(itemStack){

            @Override
            public int fill(FluidStack resource, boolean doFill) {
                int result = super.fill(resource, doFill);
                if (result > 0) {
                    ItemStack container = this.getContainer();
                    IToolItem plunger = (IToolItem)container.func_77973_b();
                    double operations = result;
                    int damage = (int)Math.ceil(operations /= 1000.0);
                    result = 1000 * plunger.damageItem(container, damage, true, !doFill);
                }
                return result;
            }
        };
    }
}

