/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.Materials;
import gregtech.common.ConfigHolder;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class MetaTileEntityAirCollector
extends TieredMetaTileEntity {
    private static final int PRODUCTION_CYCLE_LENGTH = 20;

    public MetaTileEntityAirCollector(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityAirCollector(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(32000)});
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            int fluidAmount;
            FluidStack fluidStack;
            long energyToConsume = GTValues.V[this.getTier()];
            if (this.checkDimension() && this.checkOpenSides() && this.getOffsetTimer() % 20L == 0L && this.energyContainer.getEnergyStored() >= energyToConsume && this.exportFluids.fill(fluidStack = Materials.Air.getFluid(fluidAmount = this.getCollectedFluidAmount()), false) == fluidAmount) {
                this.exportFluids.fill(fluidStack, true);
                this.energyContainer.removeEnergy(energyToConsume);
            }
            if (this.getOffsetTimer() % 5L == 0L) {
                this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            }
        }
    }

    private boolean checkOpenSides() {
        EnumFacing frontFacing = this.getFrontFacing();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side == frontFacing || !this.getWorld().func_175623_d(this.getPos().func_177972_a(side))) continue;
            return true;
        }
        return false;
    }

    private boolean checkDimension() {
        int dimensionId = this.getWorld().field_73011_w.getDimension();
        return IntStream.of(ConfigHolder.machineSpecific.airCollectorDimensionBlacklist).noneMatch(x -> x == dimensionId);
    }

    private int getCollectedFluidAmount() {
        return 500 * (1 << this.getTier());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        EnumFacing frontFacing = this.getFrontFacing();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_176740_k().func_176722_c()) {
                Textures.AIR_VENT_OVERLAY.renderSided(side, renderState, translation, pipeline);
                continue;
            }
            Textures.FILTER_OVERLAY.renderSided(side, renderState, translation, pipeline);
        }
        Textures.PIPE_OUT_OVERLAY.renderSided(frontFacing, renderState, translation, pipeline);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.air_collector.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.air_collector.collection_speed", (Object[])new Object[]{this.getCollectedFluidAmount(), 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VN[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.exportFluids.getTankAt(0).getCapacity()}));
    }
}

