/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IFuelInfo;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.impl.AbstractFuelInfo;
import gregtech.api.capability.impl.FluidFuelInfo;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.FuelRecipeLogic;
import gregtech.api.capability.impl.ItemFuelInfo;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.tool.ISoftHammerItem;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipes.FuelRecipe;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.render.SimpleCubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MetaTileEntityLargeBoiler
extends MultiblockWithDisplayBase
implements IFuelable {
    private static final int CONSUMPTION_MULTIPLIER = 100;
    private static final int BOILING_TEMPERATURE = 100;
    public final BoilerType boilerType;
    private int currentTemperature;
    private int fuelBurnTicksLeft;
    private int throttlePercentage = 100;
    private boolean isActive;
    private boolean wasActiveAndNeedsUpdate;
    private boolean hasNoWater;
    private int lastTickSteamOutput;
    private FluidTankList fluidImportInventory;
    private ItemHandlerList itemImportInventory;
    private FluidTankList steamOutputTank;

    public MetaTileEntityLargeBoiler(ResourceLocation metaTileEntityId, BoilerType boilerType) {
        super(metaTileEntityId);
        this.boilerType = boilerType;
        this.reinitializeStructurePattern();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityLargeBoiler(this.metaTileEntityId, this.boilerType);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.fluidImportInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.itemImportInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.steamOutputTank = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.fluidImportInventory = new FluidTankList(true, new IFluidTank[0]);
        this.itemImportInventory = new ItemHandlerList(Collections.emptyList());
        this.steamOutputTank = new FluidTankList(true, new IFluidTank[0]);
        this.currentTemperature = 0;
        this.fuelBurnTicksLeft = 0;
        this.hasNoWater = false;
        this.isActive = false;
        this.throttlePercentage = 100;
        this.replaceFireboxAsActive(false);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K && this.isStructureFormed()) {
            this.replaceFireboxAsActive(false);
        }
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_boiler.temperature", new Object[]{this.currentTemperature, this.boilerType.maxTemperature}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_boiler.steam_output", new Object[]{this.lastTickSteamOutput, this.boilerType.baseSteamOutput}));
            TextComponentTranslation heatEffText = new TextComponentTranslation("gregtech.multiblock.large_boiler.heat_efficiency", new Object[]{(int)(this.getHeatEfficiencyMultiplier() * 100.0)});
            AdvancedTextWidget.withHoverTextTranslate((ITextComponent)heatEffText, "gregtech.multiblock.large_boiler.heat_efficiency.tooltip");
            textList.add((ITextComponent)heatEffText);
            TextComponentTranslation throttleText = new TextComponentTranslation("gregtech.multiblock.large_boiler.throttle", new Object[]{this.throttlePercentage, (int)(this.getThrottleEfficiency() * 100.0)});
            AdvancedTextWidget.withHoverTextTranslate((ITextComponent)throttleText, "gregtech.multiblock.large_boiler.throttle.tooltip");
            textList.add((ITextComponent)throttleText);
            TextComponentTranslation buttonText = new TextComponentTranslation("gregtech.multiblock.large_boiler.throttle_modify", new Object[0]);
            buttonText.func_150258_a(" ");
            buttonText.func_150257_a(AdvancedTextWidget.withButton((ITextComponent)new TextComponentString("[-]"), "sub"));
            buttonText.func_150258_a(" ");
            buttonText.func_150257_a(AdvancedTextWidget.withButton((ITextComponent)new TextComponentString("[+]"), "add"));
            textList.add((ITextComponent)buttonText);
        }
    }

    @Override
    protected void handleDisplayClick(String componentData, Widget.ClickData clickData) {
        super.handleDisplayClick(componentData, clickData);
        int modifier = componentData.equals("add") ? 1 : -1;
        int result = (clickData.isShiftClick ? 1 : 5) * modifier;
        this.throttlePercentage = MathHelper.func_76125_a((int)(this.throttlePercentage + result), (int)20, (int)100);
    }

    private double getHeatEfficiencyMultiplier() {
        double temperature = (double)this.currentTemperature / ((double)this.boilerType.maxTemperature * 1.0);
        return 1.0 + (double)Math.round((double)this.boilerType.temperatureEffBuff * temperature) / 100.0;
    }

    @Override
    protected void updateFormedValid() {
        if (this.fuelBurnTicksLeft > 0 && this.currentTemperature < this.boilerType.maxTemperature) {
            --this.fuelBurnTicksLeft;
            if (this.getOffsetTimer() % 20L == 0L) {
                ++this.currentTemperature;
            }
            if (this.fuelBurnTicksLeft == 0) {
                this.wasActiveAndNeedsUpdate = true;
            }
        } else if (this.currentTemperature > 0 && this.getOffsetTimer() % 20L == 0L) {
            --this.currentTemperature;
        }
        this.lastTickSteamOutput = 0;
        if (this.currentTemperature >= 100) {
            boolean doWaterDrain = this.getOffsetTimer() % 20L == 0L;
            FluidStack drainedWater = this.fluidImportInventory.drain(ModHandler.getWater(1), doWaterDrain);
            if (drainedWater == null || drainedWater.amount == 0) {
                drainedWater = this.fluidImportInventory.drain(ModHandler.getDistilledWater(1), doWaterDrain);
            }
            if (drainedWater != null && drainedWater.amount > 0) {
                if (this.currentTemperature > 100 && this.hasNoWater) {
                    float explosionPower = (float)this.currentTemperature / 100.0f * 2.0f;
                    this.getWorld().func_175698_g(this.getPos());
                    this.getWorld().func_72876_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, explosionPower, true);
                }
                this.hasNoWater = false;
                if (this.currentTemperature >= 100) {
                    double outputMultiplier = (double)this.currentTemperature / ((double)this.boilerType.maxTemperature * 1.0) * this.getThrottleMultiplier() * this.getThrottleEfficiency();
                    int steamOutput = (int)((double)this.boilerType.baseSteamOutput * outputMultiplier);
                    FluidStack steamStack = ModHandler.getSteam(steamOutput);
                    this.steamOutputTank.fill(steamStack, true);
                    this.lastTickSteamOutput = steamOutput;
                }
            } else {
                this.hasNoWater = true;
            }
        } else {
            this.hasNoWater = false;
        }
        if (this.fuelBurnTicksLeft == 0) {
            double heatEfficiency = this.getHeatEfficiencyMultiplier();
            int fuelMaxBurnTime = (int)Math.round((double)this.setupRecipeAndConsumeInputs() * heatEfficiency);
            if (fuelMaxBurnTime > 0) {
                this.fuelBurnTicksLeft = fuelMaxBurnTime;
                if (this.wasActiveAndNeedsUpdate) {
                    this.wasActiveAndNeedsUpdate = false;
                } else {
                    this.setActive(true);
                }
                this.markDirty();
            }
        }
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
            this.setActive(false);
        }
    }

    private int setupRecipeAndConsumeInputs() {
        for (IFluidTank fluidTank : this.fluidImportInventory.getFluidTanks()) {
            int fuelAmountToConsume;
            FluidStack fuelStack = fluidTank.drain(Integer.MAX_VALUE, false);
            if (fuelStack == null || ModHandler.isWater(fuelStack)) continue;
            FuelRecipe dieselRecipe = RecipeMaps.DIESEL_GENERATOR_FUELS.findRecipe(GTValues.V[9], fuelStack);
            if (dieselRecipe != null) {
                int fuelAmountToConsume2 = (int)Math.ceil((double)((float)(dieselRecipe.getRecipeFluid().amount * 100) * this.boilerType.fuelConsumptionMultiplier) * this.getThrottleMultiplier());
                if (fuelStack.amount < fuelAmountToConsume2) continue;
                fluidTank.drain(fuelAmountToConsume2, true);
                long recipeVoltage = FuelRecipeLogic.getTieredVoltage(dieselRecipe.getMinVoltage());
                int voltageMultiplier = (int)Math.max(1L, recipeVoltage / GTValues.V[1]);
                return (int)Math.ceil((double)(dieselRecipe.getDuration() * 100) / 2.0 * (double)voltageMultiplier * this.getThrottleMultiplier());
            }
            FuelRecipe denseFuelRecipe = RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.findRecipe(GTValues.V[9], fuelStack);
            if (denseFuelRecipe == null || fuelStack.amount < (fuelAmountToConsume = (int)Math.ceil((double)((float)(denseFuelRecipe.getRecipeFluid().amount * 100) * this.boilerType.fuelConsumptionMultiplier) * this.getThrottleMultiplier()))) continue;
            fluidTank.drain(fuelAmountToConsume, true);
            long recipeVoltage = FuelRecipeLogic.getTieredVoltage(denseFuelRecipe.getMinVoltage());
            int voltageMultiplier = (int)Math.max(1L, recipeVoltage / GTValues.V[1]);
            return (int)Math.ceil((double)(denseFuelRecipe.getDuration() * 100 * 2 * voltageMultiplier) * this.getThrottleMultiplier());
        }
        for (int slotIndex = 0; slotIndex < this.itemImportInventory.getSlots(); ++slotIndex) {
            ItemStack itemStack = this.itemImportInventory.getStackInSlot(slotIndex);
            int fuelBurnValue = (int)Math.ceil((double)TileEntityFurnace.func_145952_a((ItemStack)itemStack) / (50.0 * (double)this.boilerType.fuelConsumptionMultiplier * this.getThrottleMultiplier()));
            if (fuelBurnValue <= 0) continue;
            if (itemStack.func_190916_E() == 1) {
                ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                this.itemImportInventory.setStackInSlot(slotIndex, containerItem);
            } else {
                itemStack.func_190918_g(1);
                this.itemImportInventory.setStackInSlot(slotIndex, itemStack);
            }
            return fuelBurnValue;
        }
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("CurrentTemperature", this.currentTemperature);
        data.func_74768_a("FuelBurnTicksLeft", this.fuelBurnTicksLeft);
        data.func_74757_a("HasNoWater", this.hasNoWater);
        data.func_74768_a("ThrottlePercentage", this.throttlePercentage);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.currentTemperature = data.func_74762_e("CurrentTemperature");
        this.fuelBurnTicksLeft = data.func_74762_e("FuelBurnTicksLeft");
        this.hasNoWater = data.func_74767_n("HasNoWater");
        if (data.func_74764_b("ThrottlePercentage")) {
            this.throttlePercentage = data.func_74762_e("ThrottlePercentage");
        }
        this.isActive = this.fuelBurnTicksLeft > 0;
    }

    private void setActive(boolean active) {
        this.isActive = active;
        if (!this.getWorld().field_72995_K) {
            if (this.isStructureFormed()) {
                this.replaceFireboxAsActive(active);
            }
            this.writeCustomData(100, buf -> buf.writeBoolean(this.isActive));
            this.markDirty();
        }
    }

    private double getThrottleMultiplier() {
        return (double)this.throttlePercentage / 100.0;
    }

    private double getThrottleEfficiency() {
        return MathHelper.func_151237_a((double)(1.0 + 0.3 * Math.log(this.getThrottleMultiplier())), (double)0.4, (double)1.0);
    }

    private void replaceFireboxAsActive(boolean isActive) {
        BlockPos centerPos = this.getPos().func_177972_a(this.getFrontFacing().func_176734_d()).func_177977_b();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos blockPos = centerPos.func_177982_a(x, 0, z);
                IBlockState blockState = this.getWorld().func_180495_p(blockPos);
                if (!(blockState.func_177230_c() instanceof BlockFireboxCasing)) continue;
                blockState = blockState.func_177226_a((IProperty)BlockFireboxCasing.ACTIVE, (Comparable)Boolean.valueOf(isActive));
                this.getWorld().func_175656_a(blockPos, blockState);
            }
        }
    }

    @Override
    public int getLightValueForPart(IMultiblockPart sourcePart) {
        return sourcePart == null ? 0 : (this.isActive ? 15 : 0);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isActive = buf.readBoolean();
        }
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return this.boilerType == null ? null : FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").setAmountAtLeast('X', 4).setAmountAtLeast('C', 20).where('S', this.selfPredicate()).where('P', MetaTileEntityLargeBoiler.statePredicate(this.boilerType.pipeState)).where('X', state -> MetaTileEntityLargeBoiler.statePredicate(GTUtility.getAllPropertyValues(this.boilerType.fireboxState, BlockFireboxCasing.ACTIVE)).or(MetaTileEntityLargeBoiler.abilityPartPredicate(MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.IMPORT_ITEMS)).test((BlockWorldState)state)).where('C', MetaTileEntityLargeBoiler.statePredicate(this.boilerType.casingState).or(MetaTileEntityLargeBoiler.abilityPartPredicate(MultiblockAbility.EXPORT_FLUIDS))).build();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().render(renderState, translation, pipeline, this.getFrontFacing(), this.isActive);
    }

    @Override
    @Nonnull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return this.boilerType.frontOverlay;
    }

    @Override
    protected boolean checkStructureComponents(List<IMultiblockPart> parts, Map<MultiblockAbility<Object>, List<Object>> abilities) {
        int importFluidsSize = abilities.getOrDefault(MultiblockAbility.IMPORT_FLUIDS, Collections.emptyList()).size();
        return importFluidsSize >= 1 && (importFluidsSize >= 2 || abilities.containsKey(MultiblockAbility.IMPORT_ITEMS)) && abilities.containsKey(MultiblockAbility.EXPORT_FLUIDS);
    }

    private boolean isFireboxPart(IMultiblockPart sourcePart) {
        return this.isStructureFormed() && ((MetaTileEntity)((Object)sourcePart)).getPos().func_177956_o() < this.getPos().func_177956_o();
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null && this.isFireboxPart(sourcePart)) {
            return this.isActive ? this.boilerType.firefoxActiveRenderer : this.boilerType.fireboxIdleRenderer;
        }
        return this.boilerType.solidCasingRenderer;
    }

    @Override
    public boolean shouldRenderOverlay(IMultiblockPart sourcePart) {
        return sourcePart == null || !this.isFireboxPart(sourcePart);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (!itemStack.func_190926_b() && itemStack.hasCapability(GregtechCapabilities.CAPABILITY_MALLET, null)) {
            ISoftHammerItem softHammerItem = (ISoftHammerItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_MALLET, null);
            if (this.getWorld().field_72995_K) {
                return true;
            }
            if (!softHammerItem.damageItem(3, false)) {
                return false;
            }
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T result = super.getCapability(capability, side);
        if (result != null) {
            return result;
        }
        if (capability == GregtechCapabilities.CAPABILITY_FUELABLE) {
            return (T)GregtechCapabilities.CAPABILITY_FUELABLE.cast((Object)this);
        }
        return null;
    }

    @Override
    public Collection<IFuelInfo> getFuels() {
        int slotIndex;
        FluidStack fuelStack;
        if (!this.isStructureFormed()) {
            return Collections.emptySet();
        }
        LinkedHashMap<String, AbstractFuelInfo> fuels = new LinkedHashMap<String, AbstractFuelInfo>();
        int fluidCapacity = 0;
        for (IFluidTank fluidTank : this.fluidImportInventory.getFluidTanks()) {
            fuelStack = fluidTank.drain(Integer.MAX_VALUE, false);
            if (ModHandler.isWater(fuelStack)) continue;
            fluidCapacity += fluidTank.getCapacity();
        }
        for (IFluidTank fluidTank : this.fluidImportInventory.getFluidTanks()) {
            FuelRecipe denseFuelRecipe;
            fuelStack = fluidTank.drain(Integer.MAX_VALUE, false);
            if (fuelStack == null || ModHandler.isWater(fuelStack)) continue;
            FuelRecipe dieselRecipe = RecipeMaps.DIESEL_GENERATOR_FUELS.findRecipe(GTValues.V[9], fuelStack);
            if (dieselRecipe != null) {
                long recipeVoltage = FuelRecipeLogic.getTieredVoltage(dieselRecipe.getMinVoltage());
                int voltageMultiplier = (int)Math.max(1L, recipeVoltage / GTValues.V[1]);
                int burnTime = (int)Math.ceil((double)(dieselRecipe.getDuration() * 100) / 2.0 * (double)voltageMultiplier * this.getThrottleMultiplier());
                int fuelAmountToConsume = (int)Math.ceil((double)((float)(dieselRecipe.getRecipeFluid().amount * 100) * this.boilerType.fuelConsumptionMultiplier) * this.getThrottleMultiplier());
                long fuelBurnTime = fuelStack.amount * burnTime / fuelAmountToConsume;
                FluidFuelInfo fluidFuelInfo = (FluidFuelInfo)fuels.get(fuelStack.getUnlocalizedName());
                if (fluidFuelInfo == null) {
                    fluidFuelInfo = new FluidFuelInfo(fuelStack, fuelStack.amount, fluidCapacity, fuelAmountToConsume, fuelBurnTime);
                    fuels.put(fuelStack.getUnlocalizedName(), fluidFuelInfo);
                } else {
                    fluidFuelInfo.addFuelRemaining(fuelStack.amount);
                    fluidFuelInfo.addFuelBurnTime(fuelBurnTime);
                }
            }
            if ((denseFuelRecipe = RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.findRecipe(GTValues.V[9], fuelStack)) == null) continue;
            long recipeVoltage = FuelRecipeLogic.getTieredVoltage(denseFuelRecipe.getMinVoltage());
            int voltageMultiplier = (int)Math.max(1L, recipeVoltage / GTValues.V[1]);
            int burnTime = (int)Math.ceil((double)(denseFuelRecipe.getDuration() * 100 * 2 * voltageMultiplier) * this.getThrottleMultiplier());
            int fuelAmountToConsume = (int)Math.ceil((double)((float)(denseFuelRecipe.getRecipeFluid().amount * 100) * this.boilerType.fuelConsumptionMultiplier) * this.getThrottleMultiplier());
            long fuelBurnTime = fuelStack.amount * burnTime / fuelAmountToConsume;
            FluidFuelInfo fluidFuelInfo = (FluidFuelInfo)fuels.get(fuelStack.getUnlocalizedName());
            if (fluidFuelInfo == null) {
                fluidFuelInfo = new FluidFuelInfo(fuelStack, fuelStack.amount, fluidCapacity, fuelAmountToConsume, fuelBurnTime);
                fuels.put(fuelStack.getUnlocalizedName(), fluidFuelInfo);
                continue;
            }
            fluidFuelInfo.addFuelRemaining(fuelStack.amount);
            fluidFuelInfo.addFuelBurnTime(fuelBurnTime);
        }
        int itemCapacity = 0;
        for (slotIndex = 0; slotIndex < this.itemImportInventory.getSlots(); ++slotIndex) {
            itemCapacity += this.itemImportInventory.getSlotLimit(slotIndex);
        }
        for (slotIndex = 0; slotIndex < this.itemImportInventory.getSlots(); ++slotIndex) {
            ItemStack itemStack = this.itemImportInventory.getStackInSlot(slotIndex);
            long burnTime = (int)Math.ceil((double)TileEntityFurnace.func_145952_a((ItemStack)itemStack) / (50.0 * (double)this.boilerType.fuelConsumptionMultiplier * this.getThrottleMultiplier()));
            if (burnTime <= 0L) continue;
            ItemFuelInfo itemFuelInfo = (ItemFuelInfo)fuels.get(itemStack.func_77977_a());
            if (itemFuelInfo == null) {
                itemFuelInfo = new ItemFuelInfo(itemStack, itemStack.func_190916_E(), itemCapacity, 1, (long)itemStack.func_190916_E() * burnTime);
                fuels.put(itemStack.func_77977_a(), itemFuelInfo);
                continue;
            }
            itemFuelInfo.addFuelRemaining(itemStack.func_190916_E());
            itemFuelInfo.addFuelBurnTime((long)itemStack.func_190916_E() * burnTime);
        }
        return fuels.values();
    }

    public static enum BoilerType {
        BRONZE(900, 1.0f, 28, 500, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.BRONZE_BRICKS), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.BRONZE_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.BRONZE_PIPE), Textures.BRONZE_PLATED_BRICKS, Textures.BRONZE_FIREBOX, Textures.BRONZE_FIREBOX_ACTIVE, Textures.LARGE_BRONZE_BOILER),
        STEEL(1600, 1.6f, 30, 800, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.STEEL_PIPE), Textures.SOLID_STEEL_CASING, Textures.STEEL_FIREBOX, Textures.STEEL_FIREBOX_ACTIVE, Textures.LARGE_STEEL_BOILER),
        TITANIUM(3700, 3.0f, 31, 2000, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.TITANIUM_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.TITANIUM_PIPE), Textures.STABLE_TITANIUM_CASING, Textures.TITANIUM_FIREBOX, Textures.TITANIUM_FIREBOX_ACTIVE, Textures.LARGE_TITANIUM_BOILER),
        TUNGSTENSTEEL(7800, 5.4f, 32, 4000, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE), Textures.ROBUST_TUNGSTENSTEEL_CASING, Textures.TUNGSTENSTEEL_FIREBOX, Textures.TUNGSTENSTEEL_FIREBOX_ACTIVE, Textures.LARGE_TUNGSTENSTEEL_BOILER);

        public final int baseSteamOutput;
        public final float fuelConsumptionMultiplier;
        public final int temperatureEffBuff;
        public final int maxTemperature;
        public final IBlockState casingState;
        public final IBlockState fireboxState;
        public final IBlockState pipeState;
        public final ICubeRenderer solidCasingRenderer;
        public final SimpleCubeRenderer fireboxIdleRenderer;
        public final SimpleCubeRenderer firefoxActiveRenderer;
        public final OrientedOverlayRenderer frontOverlay;

        @Deprecated
        private BoilerType(int baseSteamOutput, float fuelConsumptionMultiplier, int temperatureEffBuff, int maxTemperature, IBlockState casingState, IBlockState fireboxState, IBlockState pipeState, ICubeRenderer solidCasingRenderer, SimpleCubeRenderer fireboxIdleRenderer, SimpleCubeRenderer firefoxActiveRenderer) {
            this.baseSteamOutput = baseSteamOutput;
            this.fuelConsumptionMultiplier = fuelConsumptionMultiplier;
            this.temperatureEffBuff = temperatureEffBuff;
            this.maxTemperature = maxTemperature;
            this.casingState = casingState;
            this.fireboxState = fireboxState;
            this.pipeState = pipeState;
            this.solidCasingRenderer = solidCasingRenderer;
            this.fireboxIdleRenderer = fireboxIdleRenderer;
            this.firefoxActiveRenderer = firefoxActiveRenderer;
            this.frontOverlay = Textures.MULTIBLOCK_WORKABLE_OVERLAY;
        }

        private BoilerType(int baseSteamOutput, float fuelConsumptionMultiplier, int temperatureEffBuff, int maxTemperature, IBlockState casingState, IBlockState fireboxState, IBlockState pipeState, ICubeRenderer solidCasingRenderer, SimpleCubeRenderer fireboxIdleRenderer, SimpleCubeRenderer firefoxActiveRenderer, OrientedOverlayRenderer frontOverlay) {
            this.baseSteamOutput = baseSteamOutput;
            this.fuelConsumptionMultiplier = fuelConsumptionMultiplier;
            this.temperatureEffBuff = temperatureEffBuff;
            this.maxTemperature = maxTemperature;
            this.casingState = casingState;
            this.fireboxState = fireboxState;
            this.pipeState = pipeState;
            this.solidCasingRenderer = solidCasingRenderer;
            this.fireboxIdleRenderer = fireboxIdleRenderer;
            this.firefoxActiveRenderer = firefoxActiveRenderer;
            this.frontOverlay = frontOverlay;
        }
    }
}

