/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IFuelInfo;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.impl.ItemFuelInfo;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SteamCoalBoiler
extends SteamBoiler
implements IFuelable {
    public SteamCoalBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.COAL_BOILER_OVERLAY, 150);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new SteamCoalBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected void tryConsumeNewFuel() {
        ItemStack fuelInSlot = this.importItems.extractItem(0, 1, true);
        if (fuelInSlot.func_190926_b()) {
            return;
        }
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelInSlot);
        if (burnTime <= 0) {
            return;
        }
        this.importItems.extractItem(0, 1, false);
        ItemStack remainderAsh = ModHandler.getBurningFuelRemainder(this.getWorld().field_73012_v, fuelInSlot);
        if (!remainderAsh.func_190926_b()) {
            this.exportItems.insertItem(0, remainderAsh, false);
        }
        this.setFuelMaxBurnTime(burnTime);
    }

    @Override
    public IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T result = super.getCapability(capability, side);
        if (result != null) {
            return result;
        }
        if (capability == GregtechCapabilities.CAPABILITY_FUELABLE) {
            return (T)GregtechCapabilities.CAPABILITY_FUELABLE.cast((Object)this);
        }
        return null;
    }

    @Override
    public Collection<IFuelInfo> getFuels() {
        ItemStack fuelInSlot = this.importItems.extractItem(0, Integer.MAX_VALUE, true);
        if (fuelInSlot == null || fuelInSlot.func_190926_b()) {
            return Collections.emptySet();
        }
        int fuelRemaining = fuelInSlot.func_190916_E();
        int fuelCapacity = this.importItems.getSlotLimit(0);
        long burnTime = fuelRemaining * TileEntityFurnace.func_145952_a((ItemStack)fuelInSlot) * (this.isHighPressure ? 6 : 12);
        return Collections.singleton(new ItemFuelInfo(fuelInSlot, fuelRemaining, fuelCapacity, 1, burnTime));
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).widget(new SlotWidget(this.importItems, 0, 115, 54).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE, this.SLOT_FURNACE_BACKGROUND)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 115, 18, true, false).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE)).widget(new ProgressWidget(this::getFuelLeftPercent, 114, 35, 18, 18).setProgressBar(this.getGuiTexture("boiler_%s_fuel"), this.getGuiTexture("boiler_%s_fuel_full"), ProgressWidget.MoveType.VERTICAL)).build(this.getHolder(), player);
    }
}

