/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import com.google.common.collect.Lists;
import gregtech.api.util.DummyContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.inventory.itemsource.ItemSourceList;
import gregtech.common.inventory.itemsource.sources.TileItemSource;
import gregtech.common.metatileentities.storage.CachedRecipeData;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CraftingRecipeResolver {
    private final World world;
    private final ItemSourceList itemSourceList;
    private final ItemStackHandler craftingGrid;
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
    private IRecipe cachedRecipe = null;
    private final IInventory craftingResultInventory = new InventoryCraftResult();
    private long timer = 0L;
    private CachedRecipeData cachedRecipeData = null;
    private int itemsCrafted = 0;
    private final CraftingRecipeMemory recipeMemory;

    public CraftingRecipeResolver(World world, ItemStackHandler craftingGrid, CraftingRecipeMemory recipeMemory) {
        this.world = world;
        this.craftingGrid = craftingGrid;
        this.recipeMemory = recipeMemory;
        this.itemSourceList = new ItemSourceList(world);
        this.itemSourceList.addItemListChangeCallback(this::notifyStoredItemsChanged);
    }

    public ItemSourceList getItemSourceList() {
        return this.itemSourceList;
    }

    public IInventory getCraftingResultInventory() {
        return this.craftingResultInventory;
    }

    public int getItemsCrafted() {
        return this.itemsCrafted;
    }

    public void setItemsCrafted(int itemsCrafted) {
        this.itemsCrafted = itemsCrafted;
    }

    public void clearCraftingGrid() {
        this.setCraftingGrid(Collections.emptyMap());
    }

    public void setCraftingGrid(Map<Integer, ItemStack> ingredients) {
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            this.craftingGrid.setStackInSlot(i, ingredients.getOrDefault(i + 1, ItemStack.field_190927_a));
        }
    }

    private boolean updateInventoryCrafting() {
        boolean craftingGridChanged = false;
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            ItemStack inventoryCraftingStack;
            ItemStack craftingGridStack = this.craftingGrid.getStackInSlot(i);
            if (ItemStack.func_179545_c((ItemStack)craftingGridStack, (ItemStack)(inventoryCraftingStack = this.inventoryCrafting.func_70301_a(i))) && ItemStack.func_77970_a((ItemStack)craftingGridStack, (ItemStack)inventoryCraftingStack)) continue;
            this.inventoryCrafting.func_70299_a(i, craftingGridStack.func_77946_l());
            craftingGridChanged = true;
        }
        return craftingGridChanged;
    }

    public void performRecipe(EntityPlayer player) {
        if (this.cachedRecipeData != null) {
            this.itemSourceList.disableCallback();
            this.cachedRecipeData.performRecipe(player);
            InvWrapper invWrapper = new InvWrapper((IInventory)this.cachedRecipeData.inventory);
            GTUtility.copyInventoryItems((IItemHandler)invWrapper, (IItemHandlerModifiable)this.craftingGrid);
            GTUtility.copyInventoryItems((IItemHandler)invWrapper, (IItemHandlerModifiable)new InvWrapper((IInventory)this.inventoryCrafting));
            this.itemSourceList.enableCallback();
        }
    }

    public void handleItemCraft(ItemStack itemStack, EntityPlayer player, boolean simulate) {
        itemStack.func_77980_a(this.world, player, 1);
        itemStack.func_77973_b().func_77622_d(itemStack, this.world, player);
        if (!simulate) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, (IInventory)this.inventoryCrafting);
            if (this.cachedRecipe != null && !this.cachedRecipe.func_192399_d()) {
                player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{this.cachedRecipe}));
            }
            if (this.cachedRecipe != null) {
                ItemStack resultStack = this.cachedRecipe.func_77572_b(this.inventoryCrafting);
                this.itemsCrafted += resultStack.func_190916_E();
                this.recipeMemory.notifyRecipePerformed((IItemHandler)this.craftingGrid, resultStack);
            }
        }
    }

    public void refreshOutputSlot() {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (this.cachedRecipe != null) {
            itemStack = this.cachedRecipe.func_77572_b(this.inventoryCrafting).func_77946_l();
        }
        this.craftingResultInventory.func_70299_a(0, itemStack);
    }

    public boolean checkRecipeValid() {
        return this.cachedRecipeData != null && this.cachedRecipeData.checkRecipeValid();
    }

    private void notifyStoredItemsChanged() {
        if (this.cachedRecipeData != null) {
            GTUtility.copyInventoryItems((IItemHandler)this.craftingGrid, (IItemHandlerModifiable)new InvWrapper((IInventory)this.cachedRecipeData.inventory));
            this.cachedRecipeData.attemptMatchRecipe();
        }
    }

    private void updateCurrentRecipe() {
        IRecipe newRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.inventoryCrafting, (World)this.world);
        if (this.cachedRecipe != newRecipe) {
            this.cachedRecipe = newRecipe;
            if (newRecipe != null) {
                ItemStack resultStack = newRecipe.func_77572_b(this.inventoryCrafting).func_77946_l();
                this.craftingResultInventory.func_70299_a(0, resultStack.func_77946_l());
                this.cachedRecipeData = new CachedRecipeData(this.itemSourceList, newRecipe, resultStack.func_77946_l());
                GTUtility.copyInventoryItems((IItemHandler)this.craftingGrid, (IItemHandlerModifiable)new InvWrapper((IInventory)this.cachedRecipeData.inventory));
                this.cachedRecipeData.attemptMatchRecipe();
            } else {
                this.craftingResultInventory.func_70299_a(0, ItemStack.field_190927_a);
                this.cachedRecipeData = null;
            }
        }
    }

    public void update() {
        if (this.timer % 20L == 0L) {
            this.itemSourceList.func_73660_a();
        }
        if (this.updateInventoryCrafting()) {
            this.updateCurrentRecipe();
        }
        ++this.timer;
    }

    public void checkNeighbourInventories(BlockPos blockPos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileItemSource itemSource = new TileItemSource(this.world, blockPos, side);
            this.itemSourceList.addItemHandler(itemSource);
        }
    }
}

