/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityQuantumChest
extends MetaTileEntity
implements ITieredMetaTileEntity {
    private static final double[] rotations = new double[]{180.0, 0.0, -90.0, 90.0};
    private final int tier;
    private final long maxStoredItems;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private long itemsStoredInside = 0L;
    private static final String NBT_ITEMSTACK = "ItemStack";
    private static final String NBT_PARTIALSTACK = "PartialStack";
    private static final String NBT_ITEMCOUNT = "ItemAmount";

    public MetaTileEntityQuantumChest(ResourceLocation metaTileEntityId, int tier, long maxStoredItems) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxStoredItems = maxStoredItems;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityQuantumChest(this.metaTileEntityId, this.tier, this.maxStoredItems);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[this.tier].render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        translation.translate(0.5, 0.001, 0.5);
        translation.rotate(Math.toRadians(rotations[this.getFrontFacing().func_176745_a() - 2]), new Vector3(0.0, 1.0, 0.0));
        translation.translate(-0.5, 0.0, -0.5);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColor());
    }

    @Override
    public int getActualComparatorValue() {
        float f = (float)this.itemsStoredInside / ((float)this.maxStoredItems * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (this.itemsStoredInside > 0L ? 1 : 0);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.itemsStoredInside < this.maxStoredItems) {
                ItemStack inputStack = this.importItems.getStackInSlot(0);
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                if ((outputStack.func_190926_b() || outputStack.func_77969_a(inputStack) && ItemStack.func_77970_a((ItemStack)inputStack, (ItemStack)outputStack)) && !inputStack.func_190926_b() && (this.itemStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, inputStack))) {
                    int amountOfItemsToInsert = (int)Math.min((long)inputStack.func_190916_E(), this.maxStoredItems - this.itemsStoredInside);
                    if (this.itemsStoredInside == 0L || this.itemStack.func_190926_b()) {
                        this.itemStack = GTUtility.copyAmount(1, inputStack);
                    }
                    inputStack.func_190918_g(amountOfItemsToInsert);
                    this.importItems.setStackInSlot(0, inputStack);
                    this.itemsStoredInside += (long)amountOfItemsToInsert;
                    this.markDirty();
                }
            }
            if (this.itemsStoredInside > 0L && !this.itemStack.func_190926_b()) {
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                int maxStackSize = this.itemStack.func_77976_d();
                if (outputStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, outputStack) && outputStack.func_190916_E() < maxStackSize) {
                    int amountOfItemsToRemove = (int)Math.min((long)(maxStackSize - outputStack.func_190916_E()), this.itemsStoredInside);
                    if (outputStack.func_190926_b()) {
                        outputStack = GTUtility.copyAmount(amountOfItemsToRemove, this.itemStack);
                    } else {
                        outputStack.func_190917_f(amountOfItemsToRemove);
                    }
                    this.exportItems.setStackInSlot(0, outputStack);
                    this.itemsStoredInside -= (long)amountOfItemsToRemove;
                    if (this.itemsStoredInside == 0L) {
                        this.itemStack = ItemStack.field_190927_a;
                    }
                    this.markDirty();
                }
            }
        }
    }

    private static boolean areItemStackIdentical(ItemStack first, ItemStack second) {
        return ItemStack.func_179545_c((ItemStack)first, (ItemStack)second) && ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    protected void addDisplayInformation(List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.quantum_chest.items_stored", new Object[0]));
        textList.add((ITextComponent)new TextComponentString(String.format("%,d", this.itemsStoredInside)));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.capacity", (Object[])new Object[]{this.maxStoredItems}));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String translationKey = null;
            long count = 0L;
            if (compound.func_74764_b(NBT_ITEMSTACK)) {
                translationKey = new ItemStack(compound.func_74775_l(NBT_ITEMSTACK)).func_82833_r();
                count = compound.func_74763_f(NBT_ITEMCOUNT);
            } else if (compound.func_74764_b(NBT_PARTIALSTACK)) {
                ItemStack tempStack = new ItemStack(compound.func_74775_l(NBT_PARTIALSTACK));
                translationKey = tempStack.func_82833_r();
                count = tempStack.func_190916_E();
            }
            if (translationKey != null) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.tooltip.item", (Object[])new Object[]{I18n.func_135052_a((String)translationKey, (Object[])new Object[0])}));
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.tooltip.count", (Object[])new Object[]{count}));
            }
        }
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemInventory = new QuantumChestItemHandler();
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        if (!this.itemStack.func_190926_b() && this.itemsStoredInside > 0L) {
            tagCompound.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside);
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.itemStack = new ItemStack(data.func_74775_l(NBT_ITEMSTACK));
            if (!this.itemStack.func_190926_b()) {
                this.itemsStoredInside = data.func_74763_f(NBT_ITEMCOUNT);
            }
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.itemStack = new ItemStack(itemStack.func_74775_l(NBT_ITEMSTACK));
            if (!this.itemStack.func_190926_b()) {
                this.itemsStoredInside = itemStack.func_74763_f(NBT_ITEMCOUNT);
            }
        } else if (itemStack.func_150297_b(NBT_PARTIALSTACK, 10)) {
            this.exportItems.setStackInSlot(0, new ItemStack(itemStack.func_74775_l(NBT_PARTIALSTACK)));
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        if (!this.itemStack.func_190926_b()) {
            itemStack.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
            itemStack.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside + (long)this.itemStack.func_77976_d());
        } else {
            ItemStack partialStack = this.exportItems.extractItem(0, 64, false);
            if (!partialStack.func_190926_b()) {
                itemStack.func_74782_a(NBT_PARTIALSTACK, (NBTBase)partialStack.func_77955_b(new NBTTagCompound()));
            }
        }
        this.itemStack = ItemStack.field_190927_a;
        this.itemsStoredInside = 0L;
        this.exportItems.setStackInSlot(0, ItemStack.field_190927_a);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        builder.widget(new AdvancedTextWidget(11, 20, this::addDisplayInformation, 0xFFFFFF));
        return builder.label(6, 6, this.getMetaFullName()).widget(new SlotWidget((IItemHandler)this.importItems, 0, 90, 17, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntityQuantumChest.clearInventory(itemBuffer, this.importItems);
    }

    private class QuantumChestItemHandler
    implements IItemHandler {
        private QuantumChestItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack itemStack = MetaTileEntityQuantumChest.this.itemStack;
            long itemsStored = MetaTileEntityQuantumChest.this.itemsStoredInside;
            if (itemStack.func_190926_b() || itemsStored == 0L) {
                return ItemStack.field_190927_a;
            }
            ItemStack resultStack = itemStack.func_77946_l();
            resultStack.func_190920_e((int)itemsStored);
            return resultStack;
        }

        public int getSlotLimit(int slot) {
            return (int)MetaTileEntityQuantumChest.this.maxStoredItems;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int extractedAmount = (int)Math.min((long)amount, MetaTileEntityQuantumChest.this.itemsStoredInside);
            if (MetaTileEntityQuantumChest.this.itemStack.func_190926_b() || extractedAmount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack extractedStack = MetaTileEntityQuantumChest.this.itemStack.func_77946_l();
            extractedStack.func_190920_e(extractedAmount);
            if (!simulate) {
                MetaTileEntityQuantumChest metaTileEntityQuantumChest = MetaTileEntityQuantumChest.this;
                metaTileEntityQuantumChest.itemsStoredInside = metaTileEntityQuantumChest.itemsStoredInside - (long)extractedAmount;
                if (MetaTileEntityQuantumChest.this.itemsStoredInside == 0L) {
                    MetaTileEntityQuantumChest.this.itemStack = ItemStack.field_190927_a;
                }
            }
            return extractedStack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (MetaTileEntityQuantumChest.this.itemsStoredInside > 0L && !MetaTileEntityQuantumChest.this.itemStack.func_190926_b() && !MetaTileEntityQuantumChest.areItemStackIdentical(MetaTileEntityQuantumChest.this.itemStack, stack)) {
                return stack;
            }
            long amountLeftInChest = MetaTileEntityQuantumChest.this.itemStack.func_190926_b() ? MetaTileEntityQuantumChest.this.maxStoredItems : MetaTileEntityQuantumChest.this.maxStoredItems - MetaTileEntityQuantumChest.this.itemsStoredInside;
            int insertedAmount = (int)Math.min((long)stack.func_190916_E(), amountLeftInChest);
            if (insertedAmount == 0) {
                return stack;
            }
            ItemStack remainingStack = ItemStack.field_190927_a;
            if (stack.func_190916_E() > insertedAmount) {
                remainingStack = stack.func_77946_l();
                remainingStack.func_190920_e(stack.func_190916_E() - insertedAmount);
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                if (MetaTileEntityQuantumChest.this.itemStack.func_190926_b()) {
                    MetaTileEntityQuantumChest.this.itemStack = stack.func_77946_l();
                    MetaTileEntityQuantumChest.this.itemsStoredInside = insertedAmount;
                } else {
                    MetaTileEntityQuantumChest metaTileEntityQuantumChest = MetaTileEntityQuantumChest.this;
                    metaTileEntityQuantumChest.itemsStoredInside = metaTileEntityQuantumChest.itemsStoredInside + (long)insertedAmount;
                }
            }
            return remainingStack;
        }
    }
}

