/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityQuantumTank
extends MetaTileEntity
implements ITieredMetaTileEntity {
    private static final double[] rotations = new double[]{180.0, 0.0, -90.0, 90.0};
    private final int tier;
    private final int maxFluidCapacity;
    private FluidTank fluidTank;
    private final ItemStackHandler containerInventory;

    public MetaTileEntityQuantumTank(ResourceLocation metaTileEntityId, int tier, int maxFluidCapacity) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxFluidCapacity = maxFluidCapacity;
        this.containerInventory = new ItemStackHandler(2);
        this.initializeInventory();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.fluidTank = new FluidTank(this.maxFluidCapacity);
        this.fluidInventory = this.fluidTank;
        this.importFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
        this.exportFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    public int getActualComparatorValue() {
        FluidTank fluidTank = this.fluidTank;
        int fluidAmount = fluidTank.getFluidAmount();
        int maxCapacity = fluidTank.getCapacity();
        float f = (float)fluidAmount / ((float)maxCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (fluidAmount > 0 ? 1 : 0);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.fillContainerFromInternalTank((IItemHandlerModifiable)this.containerInventory, (IItemHandlerModifiable)this.containerInventory, 0, 1);
            this.fillInternalTankFromFluidContainer((IItemHandlerModifiable)this.containerInventory, (IItemHandlerModifiable)this.containerInventory, 0, 1);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ContainerInventory", (NBTBase)this.containerInventory.serializeNBT());
        data.func_74782_a("FluidInventory", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.containerInventory.deserializeNBT(data.func_74775_l("ContainerInventory"));
        this.fluidTank.readFromNBT(data.func_74775_l("FluidInventory"));
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        this.fluidTank.readFromNBT(itemStack);
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        this.fluidTank.writeToNBT(itemStack);
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityQuantumTank.clearInventory(itemBuffer, (IItemHandlerModifiable)this.containerInventory);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityQuantumTank(this.metaTileEntityId, this.tier, this.maxFluidCapacity);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[this.tier].render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        translation.translate(0.5, 0.001, 0.5);
        translation.rotate(Math.toRadians(rotations[this.getFrontFacing().func_176745_a() - 2]), new Vector3(0.0, 1.0, 0.0));
        translation.translate(-0.5, 0.0, -0.5);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColor());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.capacity", (Object[])new Object[]{this.maxFluidCapacity}));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("FluidName")) {
            FluidStack fluidStack = new FluidStack(FluidRegistry.getFluid((String)compound.func_74779_i("FluidName")), 1000);
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.tooltip.name", (Object[])new Object[]{fluidStack.getLocalizedName()}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.tooltip.count", (Object[])new Object[]{compound.func_74762_e("Amount")}));
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        TankWidget tankWidget = new TankWidget((IFluidTank)this.fluidTank, 69, 52, 18, 18).setHideTooltip(true).setAlwaysShowFull(true);
        builder.widget(tankWidget);
        builder.label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF);
        builder.dynamicLabel(11, 30, tankWidget::getFormattedFluidAmount, 0xFFFFFF);
        builder.dynamicLabel(11, 40, tankWidget::getFluidLocalizedName, 0xFFFFFF);
        return builder.label(6, 6, this.getMetaFullName()).widget(new FluidContainerSlotWidget((IItemHandlerModifiable)this.containerInventory, 0, 90, 17, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new ImageWidget(91, 36, 14, 15, GuiTextures.TANK_ICON)).widget(new SlotWidget((IItemHandler)this.containerInventory, 1, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }
}

