/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TabGroup;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.gui.widgets.tab.ItemTabInfo;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.common.gui.widget.CraftingSlotWidget;
import gregtech.common.gui.widget.ItemListGridWidget;
import gregtech.common.gui.widget.MemorizedRecipeWidget;
import gregtech.common.inventory.itemsource.ItemSourceList;
import gregtech.common.inventory.itemsource.sources.InventoryItemSource;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import gregtech.common.metatileentities.storage.CraftingRecipeResolver;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityWorkbench
extends MetaTileEntity {
    private final ItemStackHandler internalInventory = new ItemStackHandler(18);
    private final ItemStackHandler craftingGrid = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final ItemStackHandler toolInventory = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof ToolMetaItem || stack.func_77973_b() instanceof ItemTool || stack.func_77984_f())) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private final CraftingRecipeMemory recipeMemory = new CraftingRecipeMemory(9);
    private CraftingRecipeResolver recipeResolver = null;
    private int itemsCrafted = 0;

    public MetaTileEntityWorkbench(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityWorkbench(this.metaTileEntityId);
    }

    @SideOnly(value=Side.CLIENT)
    private int getResultRenderingColor() {
        int paintingColor = this.getPaintingColorForRendering();
        if (paintingColor == 0xFFFFFF) {
            paintingColor = Materials.Bronze.materialRGB;
        }
        return paintingColor;
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.CRAFTING_TABLE.getParticleSprite(), (Object)this.getResultRenderingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        int paintingColor = this.getPaintingColorForRendering();
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(paintingColor)));
        Textures.CRAFTING_TABLE.render(renderState, translation, pipeline, Cuboid6.full, this.getFrontFacing());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("CraftingGridInventory", (NBTBase)this.craftingGrid.serializeNBT());
        data.func_74782_a("ToolInventory", (NBTBase)this.toolInventory.serializeNBT());
        data.func_74782_a("InternalInventory", (NBTBase)this.internalInventory.serializeNBT());
        data.func_74768_a("ItemsCrafted", this.recipeResolver == null ? this.itemsCrafted : this.recipeResolver.getItemsCrafted());
        data.func_74782_a("RecipeMemory", (NBTBase)this.recipeMemory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.deserializeNBT(data.func_74775_l("CraftingGridInventory"));
        this.toolInventory.deserializeNBT(data.func_74775_l("ToolInventory"));
        this.internalInventory.deserializeNBT(data.func_74775_l("InternalInventory"));
        this.itemsCrafted = data.func_74762_e("ItemsCrafted");
        this.recipeMemory.deserializeNBT(data.func_74775_l("RecipeMemory"));
    }

    private void createRecipeResolver() {
        this.recipeResolver = new CraftingRecipeResolver(this.getWorld(), this.craftingGrid, this.recipeMemory);
        this.recipeResolver.setItemsCrafted(this.itemsCrafted);
        ItemSourceList itemSourceList = this.recipeResolver.getItemSourceList();
        itemSourceList.addItemHandler(InventoryItemSource.direct(this.getWorld(), (IItemHandler)this.toolInventory, -2));
        itemSourceList.addItemHandler(InventoryItemSource.direct(this.getWorld(), (IItemHandler)this.internalInventory, -1));
        this.recipeResolver.checkNeighbourInventories(this.getPos());
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.recipeResolver == null) {
            this.createRecipeResolver();
        }
        if (!this.getWorld().field_72995_K) {
            this.getRecipeResolver().update();
        }
    }

    private CraftingRecipeResolver getRecipeResolver() {
        Preconditions.checkState((this.getWorld() != null ? 1 : 0) != 0, (Object)"getRecipeResolver called too early");
        return this.recipeResolver;
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (this.recipeResolver != null) {
            this.recipeResolver.checkNeighbourInventories(this.getPos());
        }
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.internalInventory);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.toolInventory);
    }

    private AbstractWidgetGroup createWorkbenchTab() {
        int j;
        int i;
        WidgetGroup widgetGroup = new WidgetGroup();
        CraftingRecipeResolver recipeResolver = this.getRecipeResolver();
        widgetGroup.addWidget(new ImageWidget(75, 31, 26, 26, GuiTextures.SLOT));
        widgetGroup.addWidget(new CraftingSlotWidget(recipeResolver, 0, 79, 35));
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 3; ++j2) {
                widgetGroup.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)this.craftingGrid, j2 + i2 * 3, 8 + j2 * 18, 17 + i2 * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        Supplier<String> textSupplier = () -> Integer.toString(recipeResolver.getItemsCrafted());
        widgetGroup.addWidget(new SimpleTextWidget(88, 64, "", textSupplier));
        Consumer<Widget.ClickData> clearAction = clickData -> recipeResolver.clearCraftingGrid();
        widgetGroup.addWidget(new ClickButtonWidget(63, 17, 8, 8, "", clearAction).setButtonTexture(GuiTextures.BUTTON_CLEAR_GRID));
        widgetGroup.addWidget(new ImageWidget(114, 17, 54, 54, TextureArea.fullImage("textures/gui/base/darkened_slot.png")));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                widgetGroup.addWidget(new MemorizedRecipeWidget(this.recipeMemory, j + i * 3, (IItemHandlerModifiable)this.craftingGrid, 114 + j * 18, 17 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            widgetGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.toolInventory, i, 8 + i * 18, 76).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.TOOL_SLOT_OVERLAY));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                widgetGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.internalInventory, j + i * 9, 8 + j * 18, 99 + i * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        return widgetGroup;
    }

    private AbstractWidgetGroup createItemListTab() {
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.addWidget(new LabelWidget(5, 20, "gregtech.machine.workbench.storage_note_1", new Object[0]));
        widgetGroup.addWidget(new LabelWidget(5, 30, "gregtech.machine.workbench.storage_note_2", new Object[0]));
        CraftingRecipeResolver recipeResolver = this.getRecipeResolver();
        ItemSourceList itemList = recipeResolver == null ? null : recipeResolver.getItemSourceList();
        widgetGroup.addWidget(new ItemListGridWidget(2, 45, 9, 5, itemList));
        return widgetGroup;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BORDERED_BACKGROUND, 176, 221).bindPlayerInventory(entityPlayer.field_71071_by, 140);
        builder.label(5, 5, this.getMetaFullName());
        TabGroup tabGroup = new TabGroup(TabGroup.TabLocation.HORIZONTAL_TOP_LEFT, Position.ORIGIN);
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.workbench", new ItemStack(Blocks.field_150462_ai)), this.createWorkbenchTab());
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.item_list", new ItemStack((Block)Blocks.field_150486_ae)), this.createItemListTab());
        builder.widget(tabGroup);
        return builder.build(this.getHolder(), entityPlayer);
    }
}

