/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.inventory.network;

import gregtech.common.inventory.itemsource.ItemSource;
import gregtech.common.inventory.itemsource.ItemSourceList;
import gregtech.common.inventory.itemsource.sources.TileItemSource;
import gregtech.common.pipelike.inventory.network.UpdateResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemStorageNetwork
extends ItemSourceList {
    private final Map<SidedBlockPos, TileItemSource> handlerInfoMap = new HashMap<SidedBlockPos, TileItemSource>();

    public ItemStorageNetwork(World world) {
        super(world);
    }

    public void transferItemHandlers(Collection<BlockPos> nodePositions, ItemStorageNetwork destNetwork) {
        List<ItemSource> movedHandlerInfo = this.handlerInfoList.stream().filter(handlerInfo -> handlerInfo instanceof TileItemSource).filter(handlerInfo -> nodePositions.contains(((TileItemSource)handlerInfo).getBlockPos())).collect(Collectors.toList());
        movedHandlerInfo.forEach(this::removeItemHandler);
        movedHandlerInfo.forEach(destNetwork::addItemHandler);
    }

    public void handleBlockedConnectionChange(BlockPos nodePos, EnumFacing side, boolean isBlockedNow) {
        if (isBlockedNow) {
            SidedBlockPos blockPos = new SidedBlockPos(nodePos, side);
            TileItemSource handlerInfo = this.handlerInfoMap.get(blockPos);
            if (handlerInfo != null) {
                this.removeItemHandler(handlerInfo);
            }
        } else {
            TileItemSource handlerInfo = new TileItemSource(this.getWorld(), nodePos, side);
            this.addItemHandler(handlerInfo);
        }
    }

    public void checkForItemHandlers(BlockPos nodePos, int blockedConnections) {
        for (EnumFacing accessSide : EnumFacing.field_82609_l) {
            TileItemSource handlerInfo;
            if ((blockedConnections & 1 << accessSide.func_176745_a()) > 0) continue;
            SidedBlockPos blockPos = new SidedBlockPos(nodePos, accessSide);
            if (this.handlerInfoMap.containsKey(blockPos)) {
                handlerInfo = this.handlerInfoMap.get(blockPos);
                if (handlerInfo.update() != UpdateResult.INVALID) continue;
                this.removeItemHandler(handlerInfo);
                continue;
            }
            handlerInfo = new TileItemSource(this.getWorld(), nodePos, accessSide);
            this.addItemHandler(handlerInfo);
        }
    }

    @Override
    protected void addItemHandlerPost(ItemSource handlerInfo) {
        if (handlerInfo instanceof TileItemSource) {
            this.handlerInfoMap.put(ItemStorageNetwork.handlerPosition((TileItemSource)handlerInfo), (TileItemSource)handlerInfo);
        }
    }

    @Override
    protected void removeItemHandlerPost(ItemSource handlerInfo) {
        if (handlerInfo instanceof TileItemSource) {
            this.handlerInfoMap.remove(ItemStorageNetwork.handlerPosition((TileItemSource)handlerInfo));
        }
    }

    private static SidedBlockPos handlerPosition(TileItemSource handlerInfo) {
        return new SidedBlockPos(handlerInfo.getBlockPos(), handlerInfo.getAccessSide());
    }

    private static class SidedBlockPos {
        private final BlockPos blockPos;
        private final EnumFacing accessSide;

        public SidedBlockPos(BlockPos blockPos, EnumFacing accessSide) {
            this.blockPos = blockPos;
            this.accessSide = accessSide;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public EnumFacing getAccessSide() {
            return this.accessSide;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SidedBlockPos)) {
                return false;
            }
            SidedBlockPos that = (SidedBlockPos)o;
            return Objects.equals(this.blockPos, that.blockPos) && this.accessSide == that.accessSide;
        }

        public int hashCode() {
            return Objects.hash(this.blockPos, this.accessSide);
        }
    }
}

