/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ModCompatibility;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.render.ShapeModelGenerator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "fluid_pipe"), "normal");
    public static FluidPipeRenderer INSTANCE = new FluidPipeRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private Map<FluidPipeType, PipeTextureInfo> pipeTextures = new HashMap<FluidPipeType, PipeTextureInfo>();
    private Map<FluidPipeType, PipeModelInfo> pipeModels = new HashMap<FluidPipeType, PipeModelInfo>();

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_fluid_pipe");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(INSTANCE::registerIcons);
    }

    public void registerIcons(TextureMap map) {
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            ResourceLocation inLocation = new ResourceLocation("gregtech", String.format("blocks/pipe/pipe_%s_in", fluidPipeType.name));
            ResourceLocation sideLocation = new ResourceLocation("gregtech", String.format("blocks/pipe/pipe_%s_side", fluidPipeType.name));
            TextureAtlasSprite inTexture = map.func_174942_a(inLocation);
            TextureAtlasSprite sideTexture = map.func_174942_a(sideLocation);
            this.pipeTextures.put(fluidPipeType, new PipeTextureInfo(inTexture, sideTexture));
        }
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            float thickness = fluidPipeType.getThickness();
            double height = (1.0f - thickness) / 2.0f;
            int angles = 5 + fluidPipeType.ordinal();
            CCModel model = ShapeModelGenerator.generateModel(angles, height, thickness / 3.0f, height);
            CCModel fullBlockModel = ShapeModelGenerator.generateModel(angles, 1.0, thickness / 3.0f, height);
            CCModel[] rotatedVariants = ShapeModelGenerator.generateRotatedVariants(model);
            CCModel[] fullBlockVariants = ShapeModelGenerator.generateFullBlockVariants(fullBlockModel);
            this.pipeModels.put(fluidPipeType, new PipeModelInfo(rotatedVariants, fullBlockVariants));
        }
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack rawItemStack, ItemCameraTransforms.TransformType transformType) {
        ItemStack stack = ModCompatibility.getRealItemStack(rawItemStack);
        if (!(stack.func_77973_b() instanceof ItemBlockFluidPipe)) {
            return;
        }
        CCRenderState renderState = CCRenderState.instance();
        GlStateManager.func_179147_l();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)((ItemBlockFluidPipe)stack.func_77973_b()).func_179223_d();
        FluidPipeType pipeType = (FluidPipeType)blockFluidPipe.getItemPipeType(stack);
        Material material = blockFluidPipe.getItemMaterial(stack);
        if (pipeType != null && material != null) {
            this.renderPipeBlock(material, pipeType, 0x777777, renderState, new IVertexOperation[0], 0);
        }
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setBrightness(world, pos);
        BlockFluidPipe blockPipe = (BlockFluidPipe)state.func_177230_c();
        TileEntityFluidPipe tileEntityPipe = (TileEntityFluidPipe)blockPipe.getPipeTileEntity(world, pos);
        if (tileEntityPipe == null) {
            return false;
        }
        FluidPipeType fluidPipeType = (FluidPipeType)tileEntityPipe.getPipeType();
        Material pipeMaterial = tileEntityPipe.getPipeMaterial();
        int paintingColor = tileEntityPipe.getInsulationColor();
        if (fluidPipeType != null && pipeMaterial != null) {
            BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
            if (renderLayer == BlockRenderLayer.CUTOUT) {
                int connectedSidesMask = blockPipe.getActualConnections(tileEntityPipe, world);
                IVertexOperation[] pipeline = new IVertexOperation[]{new Translation((Vec3i)pos)};
                this.renderPipeBlock(pipeMaterial, fluidPipeType, paintingColor, renderState, pipeline, connectedSidesMask);
            }
            PipeCoverableImplementation coverable = tileEntityPipe.getCoverableImplementation();
            coverable.renderCovers(renderState, new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), renderLayer);
        }
        return true;
    }

    private int getPipeColor(Material material, int insulationColor) {
        if (insulationColor == 0x777777) {
            return material.materialRGB;
        }
        return insulationColor;
    }

    public boolean renderPipeBlock(Material material, FluidPipeType pipeType, int insulationColor, CCRenderState state, IVertexOperation[] pipeline, int connectMask) {
        int pipeColor = GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPipeColor(material, insulationColor));
        ColourMultiplier multiplier = new ColourMultiplier(pipeColor);
        PipeTextureInfo textureInfo = this.pipeTextures.get(pipeType);
        PipeModelInfo modelInfo = this.pipeModels.get(pipeType);
        IVertexOperation[] openingTexture = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(textureInfo.inTexture), multiplier});
        IVertexOperation[] sideTexture = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(textureInfo.sideTexture), multiplier});
        int sidedConnMask = connectMask & 0x3F;
        CCModel fullBlockModel = null;
        if (sidedConnMask == 3) {
            fullBlockModel = modelInfo.fullBlockModels[0];
        } else if (sidedConnMask == 12) {
            fullBlockModel = modelInfo.fullBlockModels[1];
        } else if (sidedConnMask == 48) {
            fullBlockModel = modelInfo.fullBlockModels[2];
        }
        if (fullBlockModel != null) {
            state.setPipeline((IVertexSource)fullBlockModel, 0, fullBlockModel.verts.length, sideTexture);
            state.render();
            return true;
        }
        Cuboid6 centerCuboid = BlockFluidPipe.getSideBox(null, pipeType.getThickness());
        state.setPipeline(openingTexture);
        BlockRenderer.renderCuboid((CCRenderState)state, (Cuboid6)centerCuboid, (int)0);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if ((connectMask & 1 << side.func_176745_a()) <= 0) continue;
            CCModel model = modelInfo.connectionModels[side.func_176745_a()];
            state.setPipeline((IVertexSource)model, 0, model.verts.length, sideTexture);
            state.render();
        }
        return true;
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)state.func_177230_c();
        IPipeTile tileEntityPipe = blockFluidPipe.getPipeTileEntity(world, pos);
        if (tileEntityPipe == null) {
            return;
        }
        FluidPipeType fluidPipeType = (FluidPipeType)tileEntityPipe.getPipeType();
        if (fluidPipeType == null) {
            return;
        }
        float thickness = fluidPipeType.getThickness();
        int connectedSidesMask = blockFluidPipe.getActualConnections(tileEntityPipe, world);
        Cuboid6 baseBox = BlockFluidPipe.getSideBox(null, thickness);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            if ((connectedSidesMask & 1 << renderSide.func_176745_a()) <= 0) continue;
            Cuboid6 sideBox = BlockFluidPipe.getSideBox(renderSide, thickness);
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)sideBox, (int)0);
        }
    }

    public void registerTextures(TextureMap map) {
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public Pair<TextureAtlasSprite, Integer> getParticleTexture(IPipeTile<FluidPipeType, FluidPipeProperties> tileEntity) {
        if (tileEntity == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        FluidPipeType fluidPipeType = tileEntity.getPipeType();
        Material material = ((TileEntityFluidPipe)tileEntity).getPipeMaterial();
        if (fluidPipeType == null || material == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        TextureAtlasSprite atlasSprite = this.pipeTextures.get((Object)fluidPipeType).sideTexture;
        int pipeColor = this.getPipeColor(material, tileEntity.getInsulationColor());
        return Pair.of((Object)atlasSprite, (Object)pipeColor);
    }

    private static class PipeModelInfo {
        public final CCModel[] connectionModels;
        public final CCModel[] fullBlockModels;

        public PipeModelInfo(CCModel[] connectionModels, CCModel[] fullBlockModels) {
            this.connectionModels = connectionModels;
            this.fullBlockModels = fullBlockModels;
        }
    }

    private static class PipeTextureInfo {
        public final TextureAtlasSprite inTexture;
        public final TextureAtlasSprite sideTexture;

        public PipeTextureInfo(TextureAtlasSprite inTexture, TextureAtlasSprite sideTexture) {
            this.inTexture = inTexture;
            this.sideTexture = sideTexture;
        }
    }
}

