/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.ModeSwitchBehavior;
import gregtech.common.tools.ToolDrillLV;
import gregtech.common.tools.ToolUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ToolJackHammer
extends ToolDrillLV {
    private static final ModeSwitchBehavior<JackHammerMode> MODE_SWITCH_BEHAVIOR = new ModeSwitchBehavior<JackHammerMode>(JackHammerMode.class);

    @Override
    public boolean canApplyEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151035_b);
    }

    @Override
    public int getToolDamagePerBlockBreak(ItemStack stack) {
        return 4;
    }

    @Override
    public int getToolDamagePerDropConversion(ItemStack stack) {
        return 4;
    }

    @Override
    public int getToolDamagePerContainerCraft(ItemStack stack) {
        return 32;
    }

    @Override
    public int getToolDamagePerEntityAttack(ItemStack stack) {
        return 8;
    }

    @Override
    public int getBaseQuality(ItemStack stack) {
        return 1;
    }

    @Override
    public float getBaseDamage(ItemStack stack) {
        return 3.0f;
    }

    @Override
    public float getDigSpeedMultiplier(ItemStack stack) {
        JackHammerMode jackHammerMode = MODE_SWITCH_BEHAVIOR.getModeFromItemStack(stack);
        return jackHammerMode.getDigSpeedMultiplier();
    }

    @Override
    public float getMaxDurabilityMultiplier(ItemStack stack) {
        return 29.0f;
    }

    @Override
    public boolean canMineBlock(IBlockState block, ItemStack stack) {
        String tool = block.func_177230_c().getHarvestTool(block);
        return tool != null && (tool.equals("hammer") || tool.equals("pickaxe")) || block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151592_s || block.func_185904_a() == Material.field_151588_w || block.func_185904_a() == Material.field_151598_x;
    }

    @Override
    public void onStatsAddedToTool(MetaItem.MetaValueItem metaValueItem) {
        metaValueItem.addComponents(MODE_SWITCH_BEHAVIOR);
    }

    @Override
    public List<BlockPos> getAOEBlocks(ItemStack itemStack, EntityPlayer player, RayTraceResult rayTraceResult) {
        if (player.func_184812_l_()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos pos = rayTraceResult.func_178782_a();
        JackHammerMode jackHammerMode = MODE_SWITCH_BEHAVIOR.getModeFromItemStack(itemStack);
        EnumFacing horizontalFacing = player.func_174811_aO();
        int xSizeExtend = (jackHammerMode.getHorizontalSize() - 1) / 2;
        int ySizeExtend = (jackHammerMode.getVerticalSize() - 1) / 2;
        for (int x = -xSizeExtend; x <= xSizeExtend; ++x) {
            for (int y = -ySizeExtend; y <= ySizeExtend; ++y) {
                BlockPos offsetPos;
                IBlockState blockState;
                if (x == 0 && y == 0 || !itemStack.func_150998_b(blockState = player.field_70170_p.func_180495_p(offsetPos = ToolJackHammer.rotate(pos, x, y, rayTraceResult.field_178784_b, horizontalFacing)))) continue;
                result.add(offsetPos);
            }
        }
        return result;
    }

    @Override
    public void onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && !(entity instanceof FakePlayer)) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            EnumFacing sideHit = ToolUtility.getSideHit(world, pos, entityPlayer);
            int damagePerBlockBreak = this.getToolDamagePerBlockBreak(stack);
            JackHammerMode jackHammerMode = MODE_SWITCH_BEHAVIOR.getModeFromItemStack(stack);
            EnumFacing horizontalFacing = entity.func_174811_aO();
            int xSizeExtend = (jackHammerMode.getHorizontalSize() - 1) / 2;
            int ySizeExtend = (jackHammerMode.getVerticalSize() - 1) / 2;
            for (int x = -xSizeExtend; x <= xSizeExtend; ++x) {
                for (int y = -ySizeExtend; y <= ySizeExtend; ++y) {
                    if (x == 0 && y == 0) continue;
                    BlockPos offsetPos = ToolJackHammer.rotate(pos, x, y, sideHit, horizontalFacing);
                    IBlockState blockState = world.func_180495_p(offsetPos);
                    if (!world.func_175660_a(entityPlayer, offsetPos) || !blockState.func_177230_c().canHarvestBlock((IBlockAccess)world, offsetPos, entityPlayer) || !(blockState.func_185903_a(entityPlayer, world, offsetPos) > 0.0f) || !stack.func_150998_b(blockState)) continue;
                    GTUtility.harvestBlock(world, offsetPos, entityPlayer);
                    ((ToolMetaItem)stack.func_77973_b()).damageItem(stack, damagePerBlockBreak, false);
                }
            }
        }
    }

    @Override
    public ItemStack getBrokenStack(ItemStack stack) {
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return MetaItems.JACKHAMMER_BASE.getChargedStackWithOverride(electricItem);
    }

    private static BlockPos rotate(BlockPos origin, int x, int y, EnumFacing sideHit, EnumFacing horizontalFacing) {
        switch (sideHit.func_176740_k()) {
            case X: {
                return origin.func_177982_a(0, y, x);
            }
            case Z: {
                return origin.func_177982_a(x, y, 0);
            }
            case Y: {
                return ToolJackHammer.rotateVertical(origin, x, y, horizontalFacing);
            }
        }
        return BlockPos.field_177992_a;
    }

    private static BlockPos rotateVertical(BlockPos origin, int x, int y, EnumFacing horizontalFacing) {
        switch (horizontalFacing.func_176740_k()) {
            case X: {
                return origin.func_177982_a(y, 0, x);
            }
            case Z: {
                return origin.func_177982_a(x, 0, y);
            }
        }
        return BlockPos.field_177992_a;
    }

    public static enum JackHammerMode implements ModeSwitchBehavior.ILocalizationKey
    {
        THREE_BY_THREE("metaitem.jack_hammer.mode.three_by_three", 3, 3, 1.2f),
        VERTICAL_LINE("metaitem.jack_hammer.mode.vertical_line", 3, 1, 2.5f),
        HORIZONTAL_LINE("metaitem.jack_hammer.mode.horizontal_line", 1, 3, 2.5f),
        SINGLE_BLOCK("metaitem.jack_hammer.mode.single_block", 1, 1, 3.0f);

        private final String localizationKey;
        private final int verticalSize;
        private final int horizontalSize;
        private final float digSpeedMultiplier;

        private JackHammerMode(String localizationKey, int verticalSize, int horizontalSize, float digSpeedMultiplier) {
            this.localizationKey = localizationKey;
            this.verticalSize = verticalSize;
            this.horizontalSize = horizontalSize;
            this.digSpeedMultiplier = digSpeedMultiplier;
        }

        public int getVerticalSize() {
            return this.verticalSize;
        }

        public int getHorizontalSize() {
            return this.horizontalSize;
        }

        public float getDigSpeedMultiplier() {
            return this.digSpeedMultiplier;
        }

        @Override
        public String getUnlocalizedName() {
            return this.localizationKey;
        }
    }
}

