/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.common.tools.ToolBase;
import gregtech.common.tools.ToolUtility;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;

public class ToolSaw
extends ToolBase {
    @Override
    public boolean canApplyEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151036_c);
    }

    @Override
    public int getToolDamagePerBlockBreak(ItemStack stack) {
        return 1;
    }

    @Override
    public int getToolDamagePerContainerCraft(ItemStack stack) {
        return 2;
    }

    @Override
    public float getBaseDamage(ItemStack stack) {
        return 3.0f;
    }

    @Override
    public boolean canMineBlock(IBlockState block, ItemStack stack) {
        String tool = block.func_177230_c().getHarvestTool(block);
        return tool != null && (tool.equals("axe") || tool.equals("saw")) || block.func_185904_a() == Material.field_151584_j || block.func_185904_a() == Material.field_151582_l || block.func_185904_a() == Material.field_151575_d || block.func_185904_a() == Material.field_151570_A || block.func_185904_a() == Material.field_151588_w || block.func_185904_a() == Material.field_151598_x;
    }

    @Override
    public boolean onBlockPreBreak(ItemStack stack, BlockPos blockPos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        boolean result = ToolUtility.applyShearBehavior(stack, blockPos, player);
        if (result) {
            ToolMetaItem toolMetaItem = (ToolMetaItem)stack.func_77973_b();
            int damagePerBlockBreak = this.getToolDamagePerBlockBreak(stack);
            toolMetaItem.damageItem(stack, damagePerBlockBreak, false);
        }
        return result;
    }

    @Override
    public void convertBlockDrops(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, List<ItemStack> dropList, ItemStack toolStack) {
        if (blockState.func_185904_a() == Material.field_151598_x || blockState.func_185904_a() == Material.field_151588_w) {
            if (blockState.func_185904_a() == Material.field_151588_w) {
                world.func_72954_a((IWorldEventListener)new IceEventListener(blockPos, world.func_82737_E()));
            }
            Item item = Item.func_150898_a((Block)blockState.func_177230_c());
            ItemStack dropStack = new ItemStack(item, 1);
            dropList.add(dropStack);
        }
    }

    @ParametersAreNonnullByDefault
    private static class IceEventListener
    implements IWorldEventListener {
        private final BlockPos blockPos;
        private final long time;

        public IceEventListener(BlockPos blockPos, long totalWorldTime) {
            this.blockPos = blockPos;
            this.time = totalWorldTime;
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            if (this.time != worldIn.func_82737_E()) {
                worldIn.func_72848_b((IWorldEventListener)this);
                return;
            }
            if (pos.equals((Object)this.blockPos) && newState.func_177230_c() == Blocks.field_150358_i) {
                worldIn.func_72848_b((IWorldEventListener)this);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), flags);
            }
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }
    }
}

