/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import gregtech.api.gui.GuiTextures;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.render.scene.SceneRenderCallback;
import gregtech.api.render.scene.WorldSceneRenderer;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackKey;
import gregtech.integration.jei.multiblock.MultiblockInfoPage;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MultiblockInfoRecipeWrapper
implements IRecipeWrapper,
SceneRenderCallback {
    private static final int MAX_PARTS = 20;
    private static final int PARTS_HEIGHT = 36;
    private final int SLOT_SIZE = 18;
    private final int SLOTS_PER_ROW = 10;
    private final int ICON_SIZE = 20;
    private final int RIGHT_PADDING = 5;
    private final MultiblockInfoPage infoPage;
    private MBPattern[] patterns;
    private Map<GuiButton, Runnable> buttons = new HashMap<GuiButton, Runnable>();
    private RecipeLayout recipeLayout;
    private List<ItemStack> allItemStackInputs = new ArrayList<ItemStack>();
    private ItemStack controllerStack;
    private int layerIndex = -1;
    private int currentRendererPage = 0;
    private int lastMouseX;
    private int lastMouseY;
    private float panX;
    private float panY;
    private float rotationYaw;
    private float rotationPitch;
    private float zoom;
    private GuiButton buttonPreviousPattern;
    private GuiButton buttonNextPattern;
    private GuiButton nextLayerButton;
    private IDrawable slot;
    private IDrawable infoIcon;
    private ItemStack tooltipBlockStack;

    public MultiblockInfoRecipeWrapper(MultiblockInfoPage infoPage) {
        this.infoPage = infoPage;
        this.controllerStack = infoPage.getController().getStackForm();
        HashSet<ItemStackKey> drops = new HashSet<ItemStackKey>();
        drops.add(new ItemStackKey(this.controllerStack));
        this.patterns = (MBPattern[])infoPage.getMatchingShapes().stream().map(it -> this.initializePattern((MultiblockShapeInfo)it, (Set<ItemStackKey>)drops)).toArray(MBPattern[]::new);
        drops.forEach(it -> this.allItemStackInputs.add(it.getItemStack()));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.allItemStackInputs);
        ingredients.setOutput(ItemStack.class, (Object)this.controllerStack);
    }

    public MultiblockInfoPage getInfoPage() {
        return this.infoPage;
    }

    public void setRecipeLayout(RecipeLayout layout, IGuiHelper guiHelper) {
        this.recipeLayout = layout;
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.infoIcon = guiHelper.drawableBuilder(GuiTextures.INFO_ICON.imageLocation, 0, 0, 20, 20).setTextureSize(20, 20).build();
        IDrawable border = layout.getRecipeCategory().getBackground();
        this.preparePlaceForParts(border.getHeight());
        this.buttons.clear();
        this.nextLayerButton = new GuiButton(0, border.getWidth() - 25, 70, 20, 20, "");
        this.buttonPreviousPattern = new GuiButton(0, border.getWidth() - 46, 90, 20, 20, "<");
        this.buttonNextPattern = new GuiButton(0, border.getWidth() - 25, 90, 20, 20, ">");
        this.buttons.put(this.nextLayerButton, this::toggleNextLayer);
        this.buttons.put(this.buttonPreviousPattern, () -> this.switchRenderPage(-1));
        this.buttons.put(this.buttonNextPattern, () -> this.switchRenderPage(1));
        boolean isPagesDisabled = this.patterns.length == 1;
        this.buttonPreviousPattern.field_146125_m = !isPagesDisabled;
        this.buttonNextPattern.field_146125_m = !isPagesDisabled;
        this.buttonPreviousPattern.field_146124_l = false;
        this.buttonNextPattern.field_146124_l = this.patterns.length > 1;
        this.panX = 0.0f;
        this.panY = 0.0f;
        this.zoom = this.infoPage.getDefaultZoom();
        this.rotationYaw = -45.0f;
        this.rotationPitch = 0.0f;
        this.currentRendererPage = 0;
        this.setNextLayer(-1);
        this.updateParts();
    }

    public WorldSceneRenderer getCurrentRenderer() {
        return this.patterns[this.currentRendererPage].sceneRenderer;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    private void toggleNextLayer() {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int height = (int)renderer.getSize().getY() - 1;
        if (++this.layerIndex > height) {
            this.layerIndex = -1;
        }
        this.setNextLayer(this.layerIndex);
    }

    private void setNextLayer(int newLayer) {
        this.layerIndex = newLayer;
        this.nextLayerButton.field_146126_j = "L:" + (this.layerIndex == -1 ? "A" : Integer.toString(this.layerIndex + 1));
    }

    private void switchRenderPage(int amount) {
        int maxIndex = this.patterns.length - 1;
        int newIndex = Math.max(0, Math.min(this.currentRendererPage + amount, maxIndex));
        if (this.currentRendererPage != newIndex) {
            this.currentRendererPage = newIndex;
            this.buttonNextPattern.field_146124_l = newIndex < maxIndex;
            this.buttonPreviousPattern.field_146124_l = newIndex > 0;
            this.updateParts();
        }
    }

    private void preparePlaceForParts(int recipeHeight) {
        GuiItemStackGroup itemStackGroup = this.recipeLayout.getItemStacks();
        for (int i = 0; i < 20; ++i) {
            itemStackGroup.init(i, true, 18 * i - 180 * (i / 10), recipeHeight - 36 + 18 * (i / 10));
        }
    }

    private void updateParts() {
        int i;
        GuiItemStackGroup itemStackGroup = this.recipeLayout.getItemStacks();
        List<ItemStack> parts = this.patterns[this.currentRendererPage].parts;
        int limit = Math.min(parts.size(), 20);
        for (i = 0; i < limit; ++i) {
            itemStackGroup.set(i, parts.get(i));
        }
        for (i = parts.size(); i < limit; ++i) {
            itemStackGroup.set(i, (ItemStack)null);
        }
    }

    private boolean shouldDisplayBlock(BlockPos pos) {
        if (this.getLayerIndex() == -1) {
            return true;
        }
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int minHeight = (int)renderer.world.getMinPos().getY();
        int relativeHeight = pos.func_177956_o() - minHeight;
        return relativeHeight == this.getLayerIndex();
    }

    @Override
    public void preRenderScene(WorldSceneRenderer renderer) {
        Vector3f size = renderer.getSize();
        Vector3f minPos = renderer.world.getMinPos();
        minPos = new Vector3f(minPos);
        minPos.add((Tuple3f)new Vector3f(0.0f, -1.0f, 0.5f));
        GlStateManager.func_179152_a((float)this.zoom, (float)this.zoom, (float)this.zoom);
        GlStateManager.func_179109_b((float)this.panX, (float)this.panY, (float)0.0f);
        GlStateManager.func_179109_b((float)(-minPos.x), (float)(-minPos.y), (float)(-minPos.z));
        Vector3 centerPosition = new Vector3((double)(size.x / 2.0f), (double)(size.y / 2.0f), (double)(size.z / 2.0f));
        GlStateManager.func_179137_b((double)centerPosition.x, (double)centerPosition.y, (double)centerPosition.z);
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179137_b((double)(-centerPosition.x), (double)(-centerPosition.y), (double)(-centerPosition.z));
        GlStateManager.func_179109_b((float)minPos.x, (float)minPos.y, (float)minPos.z);
        GlStateManager.func_179137_b((double)centerPosition.x, (double)centerPosition.y, (double)centerPosition.z);
        GlStateManager.func_179114_b((float)this.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotationPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-centerPosition.x), (double)(-centerPosition.y), (double)(-centerPosition.z));
        if (this.layerIndex >= 0) {
            GlStateManager.func_179137_b((double)0.0, (double)(-this.layerIndex + 1), (double)0.0);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int sceneHeight = recipeHeight - 36;
        renderer.render(this.recipeLayout.getPosX(), this.recipeLayout.getPosY(), recipeWidth, sceneHeight, 0xC6C6C6);
        this.drawMultiblockName(recipeWidth);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.infoIcon.draw(minecraft, recipeWidth - 25, 49);
        for (int i = 0; i < 20; ++i) {
            this.slot.draw(minecraft, 18 * i - 180 * (i / 10), sceneHeight + 18 * (i / 10));
        }
        for (GuiButton button : this.buttons.keySet()) {
            button.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        }
        this.drawHoveringInformationText(minecraft, this.infoPage.informationText(), mouseX, mouseY);
        this.tooltipBlockStack = null;
        BlockPos pos = renderer.getLastHitBlock();
        boolean insideView = mouseX >= 0 && mouseY >= 0 && mouseX < recipeWidth && mouseY < sceneHeight;
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        boolean isHoldingShift = Keyboard.isKeyDown((int)42);
        if (insideView) {
            int mouseDeltaY;
            if (leftClickHeld) {
                if (isHoldingShift) {
                    mouseDeltaY = mouseY - this.lastMouseY;
                    this.rotationPitch += (float)mouseDeltaY * 2.0f;
                } else {
                    int mouseDeltaX = mouseX - this.lastMouseX;
                    this.rotationYaw += (float)mouseDeltaX * 2.0f;
                }
            } else if (rightClickHeld) {
                mouseDeltaY = mouseY - this.lastMouseY;
                if (isHoldingShift) {
                    this.zoom = (float)((double)this.zoom * Math.pow(1.05, -mouseDeltaY));
                } else {
                    int mouseDeltaX = mouseX - this.lastMouseX;
                    this.panX -= (float)mouseDeltaX / 2.0f;
                    this.panY -= (float)mouseDeltaY / 2.0f;
                }
            }
        }
        if (!(leftClickHeld || rightClickHeld || pos == null || renderer.world.func_175623_d(pos))) {
            IBlockState blockState = renderer.world.func_180495_p(pos);
            CuboidRayTraceResult result = new CuboidRayTraceResult(new Vector3(0.5, 0.5, 0.5).add(pos), pos, EnumFacing.UP, new IndexedCuboid6(null, Cuboid6.full), 1.0);
            ItemStack itemStack = blockState.func_177230_c().getPickBlock(blockState, (RayTraceResult)result, (World)renderer.world, pos, (EntityPlayer)minecraft.field_71439_g);
            if (itemStack != null && !itemStack.func_190926_b()) {
                this.tooltipBlockStack = itemStack;
            }
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawHoveringInformationText(Minecraft minecraft, List<String> tooltip, int mouseX, int mouseY) {
        int minX = this.recipeLayout.getRecipeCategory().getBackground().getWidth();
        int[] yRange = new int[]{49, 69};
        int[] xRange = new int[]{minX - 25, minX - 5};
        if (this.isMouseWithinRange(yRange, xRange, mouseY, mouseX)) {
            GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)176, (int)176, (int)-1, (FontRenderer)minecraft.field_71466_p);
        }
    }

    private boolean isMouseWithinRange(int[] yRange, int[] xRange, int mouseY, int mouseX) {
        return yRange[0] < mouseY && mouseY < yRange[1] && xRange[0] < mouseX && mouseX < xRange[1];
    }

    private void drawMultiblockName(int recipeWidth) {
        String localizedName = I18n.func_135052_a((String)this.infoPage.getController().getMetaFullName(), (Object[])new Object[0]);
        GTUtility.drawCenteredSizedText(recipeWidth / 2, 0, localizedName, 0x333333, 1.3);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        for (Map.Entry<GuiButton, Runnable> button : this.buttons.entrySet()) {
            if (!button.getKey().func_146116_c(minecraft, mouseX, mouseY)) continue;
            button.getValue().run();
            return true;
        }
        return false;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.tooltipBlockStack != null && !this.tooltipBlockStack.func_190926_b() && !Mouse.isButtonDown((int)0)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ITooltipFlag.TooltipFlags flag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List tooltip = this.tooltipBlockStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, (ITooltipFlag)flag);
            EnumRarity rarity = this.tooltipBlockStack.func_77953_t();
            for (int k = 0; k < tooltip.size(); ++k) {
                if (k == 0) {
                    tooltip.set(k, rarity.field_77937_e + (String)tooltip.get(k));
                    continue;
                }
                tooltip.set(k, TextFormatting.GRAY + (String)tooltip.get(k));
            }
            Map<ItemStack, List<ITextComponent>> blockTooltipMap = this.infoPage.getBlockTooltipMap();
            if (blockTooltipMap.containsKey(this.tooltipBlockStack)) {
                List<ITextComponent> tooltips = blockTooltipMap.get(this.tooltipBlockStack);
                for (int i = 0; i < tooltips.size(); ++i) {
                    tooltip.add(i + 1, tooltips.get(i).func_150254_d());
                }
            }
            return tooltip;
        }
        return Collections.emptyList();
    }

    public void addBlockTooltips(int slotIndex, boolean input, ItemStack itemStack, List<String> tooltip) {
        Map<ItemStack, List<ITextComponent>> blockTooltipMap = this.infoPage.getBlockTooltipMap();
        if (blockTooltipMap.containsKey(itemStack)) {
            List<ITextComponent> tooltips = blockTooltipMap.get(itemStack);
            for (int i = 0; i < tooltips.size(); ++i) {
                tooltip.add(i + 1, tooltips.get(i).func_150254_d());
            }
        }
    }

    private static void gatherBlockDrops(World world, Map<BlockPos, BlockInfo> blocks, Set<ItemStackKey> drops, Map<ItemStackKey, PartInfo> partsMap) {
        NonNullList dropsList = NonNullList.func_191196_a();
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            IBlockState blockState = world.func_180495_p(pos);
            NonNullList blockDrops = NonNullList.func_191196_a();
            blockState.func_177230_c().getDrops(blockDrops, (IBlockAccess)world, pos, blockState, 0);
            dropsList.addAll((Collection)blockDrops);
            for (ItemStack itemStack : blockDrops) {
                ItemStackKey itemStackKey = new ItemStackKey(itemStack);
                PartInfo partInfo = partsMap.get(itemStackKey);
                if (partInfo == null) {
                    partInfo = new PartInfo(itemStackKey, entry.getValue());
                    partsMap.put(itemStackKey, partInfo);
                }
                ++partInfo.amount;
            }
        }
        for (ItemStack itemStack : dropsList) {
            drops.add(new ItemStackKey(itemStack));
        }
    }

    private MBPattern initializePattern(MultiblockShapeInfo shapeInfo, Set<ItemStackKey> blockDrops) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int z = 0; z < blocks.length; ++z) {
            BlockInfo[][] aisle = blocks[z];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int x = 0; x < column.length; ++x) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockInfo blockInfo = column[x];
                    blockMap.put(blockPos, blockInfo);
                }
            }
        }
        WorldSceneRenderer worldSceneRenderer = new WorldSceneRenderer(blockMap);
        worldSceneRenderer.world.func_72939_s();
        HashMap<ItemStackKey, PartInfo> partsMap = new HashMap<ItemStackKey, PartInfo>();
        MultiblockInfoRecipeWrapper.gatherBlockDrops(worldSceneRenderer.world, blockMap, blockDrops, partsMap);
        worldSceneRenderer.setRenderCallback(this);
        worldSceneRenderer.setRenderFilter(this::shouldDisplayBlock);
        ArrayList<PartInfo> partInfos = new ArrayList<PartInfo>(partsMap.values());
        partInfos.sort((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        });
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        for (PartInfo partInfo : partInfos) {
            parts.add(partInfo.getItemStack());
        }
        return new MBPattern(worldSceneRenderer, parts);
    }

    private static class PartInfo {
        final ItemStackKey itemStackKey;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStackKey itemStackKey, BlockInfo blockInfo) {
            this.itemStackKey = itemStackKey;
            this.blockId = Block.func_149682_b((Block)blockInfo.getBlockState().func_177230_c());
            TileEntity tileEntity = blockInfo.getTileEntity();
            if (tileEntity != null) {
                this.isTile = true;
                MetaTileEntity mte = ((MetaTileEntityHolder)tileEntity).getMetaTileEntity();
                if (mte instanceof MultiblockControllerBase) {
                    this.isController = true;
                }
            }
        }

        ItemStack getItemStack() {
            ItemStack result = this.itemStackKey.getItemStack();
            result.func_190920_e(this.amount);
            return result;
        }
    }

    private static class MBPattern {
        final WorldSceneRenderer sceneRenderer;
        final List<ItemStack> parts;

        public MBPattern(WorldSceneRenderer sceneRenderer, List<ItemStack> parts) {
            this.sceneRenderer = sceneRenderer;
            this.parts = parts;
        }
    }
}

