/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.integration.jei.utils.JEIHelpers;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTRecipeWrapper
implements IRecipeWrapper {
    private static final int LINE_HEIGHT = 10;
    private final Hash.Strategy<ItemStack> strategy = ItemStackHashStrategy.comparingAllButCount();
    private final Set<ItemStack> notConsumedInput = new ObjectOpenCustomHashSet(this.strategy);
    private final Map<ItemStack, Recipe.ChanceEntry> chanceOutput = new Object2ObjectOpenCustomHashMap(this.strategy);
    private final List<FluidStack> notConsumedFluidInput = new ArrayList<FluidStack>();
    private final Recipe recipe;

    public GTRecipeWrapper(Recipe recipe) {
        this.recipe = recipe;
    }

    @Deprecated
    public GTRecipeWrapper(RecipeMap<?> recipeMap, Recipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        List recipeOutputs;
        List<CountableIngredient> recipeInputs;
        if (!this.recipe.getInputs().isEmpty()) {
            recipeInputs = this.recipe.getInputs();
            ArrayList<List<ItemStack>> matchingInputs = new ArrayList<List<ItemStack>>(recipeInputs.size());
            for (CountableIngredient ingredient : recipeInputs) {
                List<ItemStack> ingredientValues = Arrays.stream(ingredient.getIngredient().func_193365_a()).map(ItemStack::func_77946_l).sorted(OreDictUnifier.getItemStackComparator()).collect(Collectors.toList());
                ingredientValues.forEach(stack -> {
                    if (ingredient.getCount() == 0) {
                        this.notConsumedInput.add((ItemStack)stack);
                        stack.func_190920_e(1);
                    } else {
                        stack.func_190920_e(ingredient.getCount());
                    }
                });
                matchingInputs.add(ingredientValues);
            }
            ingredients.setInputLists(VanillaTypes.ITEM, matchingInputs);
        }
        if (!this.recipe.getFluidInputs().isEmpty()) {
            recipeInputs = this.recipe.getFluidInputs().stream().map(FluidStack::copy).collect(Collectors.toList());
            recipeInputs.forEach(stack -> {
                if (stack.amount == 0) {
                    this.notConsumedFluidInput.add((FluidStack)stack);
                    stack.amount = 1;
                }
            });
            ingredients.setInputs(VanillaTypes.FLUID, recipeInputs);
        }
        if (!this.recipe.getOutputs().isEmpty() || !this.recipe.getChancedOutputs().isEmpty()) {
            recipeOutputs = this.recipe.getOutputs().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            List<Recipe.ChanceEntry> chancedOutputs = this.recipe.getChancedOutputs();
            for (Recipe.ChanceEntry chancedEntry : chancedOutputs) {
                ItemStack chancedStack = chancedEntry.getItemStack();
                this.chanceOutput.put(chancedStack, chancedEntry);
                recipeOutputs.add(chancedStack);
            }
            recipeOutputs.sort(Comparator.comparingInt(stack -> {
                Recipe.ChanceEntry chanceEntry = this.chanceOutput.get(stack);
                if (chanceEntry == null) {
                    return 0;
                }
                return chanceEntry.getChance();
            }));
            ingredients.setOutputs(VanillaTypes.ITEM, recipeOutputs);
        }
        if (!this.recipe.getFluidOutputs().isEmpty()) {
            recipeOutputs = this.recipe.getFluidOutputs().stream().map(FluidStack::copy).collect(Collectors.toList());
            ingredients.setOutputs(VanillaTypes.FLUID, recipeOutputs);
        }
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        boolean notConsumed = false;
        Recipe.ChanceEntry entry = null;
        if (ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            if (this.notConsumedFluidInput.contains(fluidStack)) {
                notConsumed = true;
            }
        } else if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            if (this.notConsumedInput.contains(itemStack)) {
                notConsumed = true;
            } else {
                entry = this.chanceOutput.get(itemStack);
            }
        } else {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredient.getClass());
        }
        if (entry != null && !input) {
            double chance = (double)entry.getChance() / 100.0;
            double boost = (double)entry.getBoostPerTier() / 100.0;
            tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.chance", (Object[])new Object[]{chance, boost}));
        } else if (notConsumed && input) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int yPosition = recipeHeight - this.getPropertyListHeight();
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.total", (Object[])new Object[]{Math.abs((long)this.recipe.getEUt()) * (long)this.recipe.getDuration()}), 0, yPosition, 0x111111);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)(this.recipe.getEUt() >= 0 ? "gregtech.recipe.eu" : "gregtech.recipe.eu_inverted"), (Object[])new Object[]{Math.abs(this.recipe.getEUt()), JEIHelpers.getMinTierForVoltage(this.recipe.getEUt())}), 0, yPosition += 10, 0x111111);
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.duration", (Object[])new Object[]{Float.valueOf((float)this.recipe.getDuration() / 20.0f)}), 0, yPosition += 10, 0x111111);
        for (Map.Entry<RecipeProperty<?>, Object> propertyEntry : this.recipe.getRecipePropertyStorage().getRecipeProperties()) {
            if (propertyEntry.getKey().isHidden()) continue;
            propertyEntry.getKey().drawInfo(minecraft, 0, yPosition += 10, 0x111111, propertyEntry.getValue());
        }
    }

    private int getPropertyListHeight() {
        return (this.recipe.getRecipePropertyStorage().getSize() + 3) * 10;
    }
}

