/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe.primitive;

import com.google.common.collect.ImmutableList;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.recipes.PrimitiveBlastFurnaceRecipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class PrimitiveBlastRecipeWrapper
implements IRecipeWrapper {
    private final PrimitiveBlastFurnaceRecipe recipe;
    private final List<List<ItemStack>> matchingInputs = new ArrayList<List<ItemStack>>();
    private final List<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();

    public PrimitiveBlastRecipeWrapper(PrimitiveBlastFurnaceRecipe recipe) {
        this.recipe = recipe;
        CountableIngredient ingredient = recipe.getInput();
        List<ItemStack> ingredientValues = Arrays.stream(ingredient.getIngredient().func_193365_a()).map(ItemStack::func_77946_l).sorted(OreDictUnifier.getItemStackComparator()).collect(Collectors.toList());
        ingredientValues.forEach(stack -> stack.func_190920_e(ingredient.getCount()));
        this.matchingInputs.add(ingredientValues);
        List<ItemStack> displayFuelStacks = MetaTileEntityPrimitiveBlastFurnace.getDisplayFuelsForRecipe(recipe.getFuelAmount());
        this.matchingInputs.add(displayFuelStacks);
        ItemStack ashesItemStack = MetaTileEntityPrimitiveBlastFurnace.getAshForRecipeFuelConsumption(recipe.getFuelAmount());
        this.outputs.add((List<ItemStack>)ImmutableList.of((Object)recipe.getOutput()));
        this.outputs.add((List<ItemStack>)ImmutableList.of((Object)ashesItemStack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.matchingInputs);
        ingredients.setOutputLists(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.duration", (Object[])new Object[]{Float.valueOf((float)this.recipe.getDuration() / 20.0f)}), 0, 55, 0x111111);
    }
}

