/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils.render;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.client.Minecraft;

public class CompositeDrawable
implements IDrawable {
    private final int width;
    private final int height;
    private final List<RenderNode> steps;

    public CompositeDrawable(int width, int height, List<RenderNode> steps) {
        this.width = width;
        this.height = height;
        this.steps = steps;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset) {
        for (RenderNode step : this.steps) {
            step.draw(minecraft, xOffset, yOffset);
        }
    }

    public static Builder startBuilder(int height, int width) {
        return new Builder(height, width);
    }

    @FunctionalInterface
    public static interface RenderNode {
        public void draw(@Nonnull Minecraft var1, int var2, int var3);
    }

    public static class Builder {
        private final int height;
        private final int width;
        private List<RenderNode> steps = new LinkedList<RenderNode>();

        public Builder(int height, int width) {
            this.height = height;
            this.width = width;
        }

        public Builder then(Runnable step) {
            return this.then((Minecraft minecraft, int xOffset, int yOffset) -> step.run());
        }

        public Builder then(RenderNode step) {
            this.steps.add(step);
            return this;
        }

        public CompositeDrawable build() {
            return new CompositeDrawable(this.width, this.height, this.steps);
        }
    }
}

