/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import java.util.ArrayList;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DebugPipeNetInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gregtech:debug_pipe_net_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ConfigHolder.debug) {
            MetaTileEntity metaTileEntity;
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (tileEntity instanceof MetaTileEntityHolder && (metaTileEntity = ((MetaTileEntityHolder)tileEntity).getMetaTileEntity()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("MetaTileEntity Id: " + metaTileEntity.metaTileEntityId);
                metaTileEntity.addDebugInfo(arrayList);
                arrayList.forEach(arg_0 -> ((IProbeInfo)probeInfo).text(arg_0));
            }
            if (tileEntity instanceof TileEntityPipeBase) {
                IPipeTile pipeTile = (IPipeTile)tileEntity;
                BlockPipe blockPipe = pipeTile.getPipeBlock();
                Object pipeNet = ((WorldPipeNet)((Object)blockPipe.getWorldPipeNet(world))).getNetFromPos(data.getPos());
                if (pipeNet != null) {
                    probeInfo.text("Net: " + pipeNet.hashCode());
                    probeInfo.text("Node Info: ");
                    StringBuilder builder = new StringBuilder();
                    Map nodeMap = ((PipeNet)pipeNet).getAllNodes();
                    Node node = nodeMap.get(data.getPos());
                    builder.append("{").append("active: ").append(node.isActive).append(", mark: ").append(node.mark).append(", blocked: ").append(node.blockedConnections).append("}");
                    probeInfo.text(builder.toString());
                }
                probeInfo.text("tile blocked: " + pipeTile.getBlockedConnections());
                if (blockPipe instanceof BlockFluidPipe && pipeTile instanceof TileEntityFluidPipeTickable) {
                    probeInfo.text("tile active: " + ((TileEntityFluidPipeTickable)pipeTile).isActive());
                }
            }
        }
    }
}

