/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.electric.MetaTileEntityTransformer;
import gregtech.integration.theoneprobe.provider.ElectricContainerInfoProvider;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TransformerInfoProvider
extends ElectricContainerInfoProvider {
    @Override
    public String getID() {
        return "gregtech:transformer_info_provider";
    }

    @Override
    protected void addProbeInfo(IEnergyContainer capability, IProbeInfo probeInfo, TileEntity tileEntity, EnumFacing sideHit) {
        MetaTileEntity metaTileEntity;
        if (tileEntity instanceof MetaTileEntityHolder && (metaTileEntity = ((MetaTileEntityHolder)tileEntity).getMetaTileEntity()) instanceof MetaTileEntityTransformer) {
            MetaTileEntityTransformer mteTransformer = (MetaTileEntityTransformer)metaTileEntity;
            String inputVoltageN = GTValues.VN[GTUtility.getTierByVoltage(capability.getInputVoltage())];
            String outputVoltageN = GTValues.VN[GTUtility.getTierByVoltage(capability.getOutputVoltage())];
            long inputAmperage = capability.getInputAmperage();
            long outputAmperage = capability.getOutputAmperage();
            IProbeInfo horizontalPane = probeInfo.vertical(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            String transformInfo = mteTransformer.isInverted() ? "{*gregtech.top.transform_up*} " : "{*gregtech.top.transform_down*} ";
            transformInfo = transformInfo + inputVoltageN + " (" + inputAmperage + "A) -> " + outputVoltageN + " (" + outputAmperage + "A)";
            horizontalPane.text(TextStyleClass.INFO + transformInfo);
            horizontalPane = probeInfo.vertical(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            if (capability.inputsEnergy(sideHit)) {
                transformInfo = "{*gregtech.top.transform_input*} " + inputVoltageN + " (" + inputAmperage + "A)";
                horizontalPane.text(TextStyleClass.INFO + transformInfo);
            } else if (capability.outputsEnergy(sideHit)) {
                transformInfo = "{*gregtech.top.transform_output*} " + outputVoltageN + " (" + outputAmperage + "A)";
                horizontalPane.text(TextStyleClass.INFO + transformInfo);
            }
        }
    }
}

